#include "waveformlabel.h"
#include <QPaintEvent>
#include <QPainter>
#include <QMouseEvent>

WaveformLabel::WaveformLabel(QWidget *parent) :
    ThumbnailLabel(parent)
{
}

void WaveformLabel::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (m_pressed) {
        painter.setOpacity(0.5);
    }

    painter.fillRect(this->rect(), Qt::black);

    if (!this->image().isNull()) {
        painter.drawImage(this->rect(), this->image());
    }

    event->accept();
}
