#include "userlistwindow.h"
#include "userlistdelegate.h"
#include "mainwindow.h"
#include "../base/userlistmodel.h"
#include <QListView>
#include <QVBoxLayout>

UserListWindow::UserListWindow(QWidget *parent) :
    QWidget(parent),
    m_model(new UserListModel(this)),
    m_view(new QListView(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new UserListDelegate(m_view));
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
}

UserListWindow::~UserListWindow() {}

void UserListWindow::setUserFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void UserListWindow::search(const QString &query) {
    this->setWindowTitle(QString("%1 ('%2')").arg(tr("Search")).arg(query));
    m_model->search(query);
}

void UserListWindow::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {

    }
}
