#ifndef TRANSFERLISTWINDOW_H
#define TRANSFERLISTWINDOW_H

#include "../base/enums.h"
#include <QWidget>

class TransferListModel;
class QListView;
class QMenu;
class QActionGroup;
class QModelIndex;
class QVBoxLayout;

class TransferListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit TransferListWindow(QWidget *parent = 0);
    ~TransferListWindow();
    
private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void pauseOrResumeSelectedTransfer();
    void cancelSelectedTransfer();
    void setSelectedTransferPriorityToHigh();
    void setSelectedTransferPriorityToNormal();
    void setSelectedTransferPriorityToLow();

private:
    TransferListModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_pauseResumeAction;
    QAction *m_cancelAction;
    QAction *m_separatorAction;
    QAction *m_highPriorityAction;
    QAction *m_normalPriorityAction;
    QAction *m_lowPriorityAction;
    QActionGroup *m_priorityActionGroup;
    QVBoxLayout *m_vbox;
};

#endif // TRANSFERLISTWINDOW_H
