#ifndef TRACKLISTWINDOW_H
#define TRACKLISTWINDOW_H

#include "../base/groupitem.h"
#include <QWidget>
#include <QSharedPointer>

class QListView;
class TrackListModel;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class TrackListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit TrackListWindow(QWidget *parent = 0);
    ~TrackListWindow();

    void setTrackFeed(const QUrl &feed);
    void getGroupTracks(QSharedPointer<GroupItem> group);
    void search(const QString &query, Queries::QueryOrder order);

private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showSelectedTrack();
    void playSelectedTrack();
    void queueSelectedTrack();
    void downloadSelectedTrack();
    void toggleFavouriteSelectedTrack();

private:
    TrackListModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_viewAction;
    QAction *m_playAction;
    QAction *m_queueAction;
    QAction *m_downloadAction;
    QAction *m_favouriteAction;
    QAction *m_separatorAction;
    QAction *m_moreResultsAction;
    QVBoxLayout *m_vbox;
};

#endif // TRACKLISTWINDOW_H
