#include "toolbar.h"
#include "../base/utils.h"
#include <QAbstractButton>
#include <QButtonGroup>
#include <QPaintEvent>
#include <QPainter>

Tab::Tab(QWidget *parent) :
    QAbstractButton(parent)
{
    this->setFixedSize(95, 58);
}

Tab::~Tab() {}

void Tab::paintEvent(QPaintEvent *event) {
    event->accept();
}

ToolBar::ToolBar(QWidget *parent) :
    QToolBar(parent),
    m_leftTab(0),
    m_rightTab(0),
    m_tabGroup(0),
    m_tabsEnabled(false)
{
    this->setAttribute(Qt::WA_OpaquePaintEvent);
    this->setFixedHeight(58);
}

ToolBar::~ToolBar() {}

void ToolBar::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (this->tabsEnabled()) {
        switch (this->currentTab()) {
        case 1:
            Utils::drawBorderImage(&painter, QRect(0, 0, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_top_right_tab.png"), 9, 206, 10, 0);
            Utils::drawBorderImage(&painter, QRect(0, 9, this->rect().width(), 40), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_right_tab.png"), 40, 206, 10, 0);
            Utils::drawBorderImage(&painter, QRect(0, 49, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_bottom_right_tab.png"), 9, 206, 10, 0);
            break;
        default:
            Utils::drawBorderImage(&painter, QRect(0, 0, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_top_left_tab.png"), 9, 206, 10, 0);
            Utils::drawBorderImage(&painter, QRect(0, 9, this->rect().width(), 40), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_left_tab.png"), 40, 206, 10, 0);
            Utils::drawBorderImage(&painter, QRect(0, 49, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_bottom_left_tab.png"), 9, 206, 10, 0);
            break;
        }
    }
    else {
        Utils::drawBorderImage(&painter, QRect(0, 0, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_top.png"), 3, 13, 6, 4);
        Utils::drawBorderImage(&painter, QRect(0, 9, this->rect().width(), 40), QImage("/usr/share/themes/default/images/qgn_plat_toolbar.png"), 40, 10, 10, 0);
        Utils::drawBorderImage(&painter, QRect(0, 49, this->rect().width(), 9), QImage("/usr/share/themes/default/images/qgn_plat_toolbar_frame_bottom.png"), 3, 13, 6, 4);
    }

    event->accept();
}

bool ToolBar::tabsEnabled() const {
    return m_tabsEnabled;
}

void ToolBar::setTabsEnabled(bool enabled) {
    if (enabled != this->tabsEnabled()) {
        m_tabsEnabled = enabled;

        if (enabled) {
            m_leftTab = new Tab(this);
            m_rightTab = new Tab(this);
            m_tabGroup = new QButtonGroup(this);
            m_leftTab->setCheckable(true);
            m_rightTab->setCheckable(true);
            m_tabGroup->addButton(m_leftTab, 0);
            m_tabGroup->addButton(m_rightTab, 1);
            m_tabGroup->setExclusive(true);

            this->addWidget(m_leftTab);
            this->addWidget(m_rightTab);

            this->connect(m_tabGroup, SIGNAL(buttonClicked(int)), this, SIGNAL(currentTabChanged(int)));
            this->setCurrentTab(0);
        }
        else {
            m_tabGroup->deleteLater();
            m_leftTab->deleteLater();
            m_rightTab->deleteLater();
            m_tabGroup = 0;
            m_leftTab = 0;
            m_rightTab = 0;
        }

        this->update();
    }
}

int ToolBar::currentTab() const {
    return !m_tabGroup ? -1 : m_tabGroup->checkedId();
}

void ToolBar::setCurrentTab(int index) {
    if (m_tabGroup) {
        foreach (QAbstractButton* button, m_tabGroup->buttons()) {
            if ((m_tabGroup->id(button) == index) && (!button->isChecked())) {
                button->setChecked(true);

                emit currentTabChanged(index);

                this->update();

                return;
            }
        }
    }
}
