#include "playlistlistwindow.h"
#include "playlistlistdelegate.h"
#include "playlisttrackswindow.h"
#include "mainwindow.h"
#include "../base/playlistlistmodel.h"
#include <QListView>
#include <QVBoxLayout>

PlaylistListWindow::PlaylistListWindow(QWidget *parent) :
    QWidget(parent),
    m_model(new PlaylistListModel(this)),
    m_view(new QListView(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new PlaylistListDelegate(m_view));
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
}

PlaylistListWindow::~PlaylistListWindow() {}

void PlaylistListWindow::setPlaylistFeed(const QUrl &feed) {
    m_model->getPlaylists(feed);
}

void PlaylistListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(QString("%1 ('%2')").arg(tr("Search")).arg(query));
    m_model->search(query, order);
}

void PlaylistListWindow::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {
        PlaylistTracksWindow *window = new PlaylistTracksWindow(m_model->get(index.row()), MainWindow::instance());
        MainWindow::instance()->push(window);
    }
}
