#include "playlistlistdelegate.h"
#include "../base/playlistlistmodel.h"
#include <QPainter>
#include <QApplication>

PlaylistListDelegate::PlaylistListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void PlaylistListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    painter->save();

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + (option.rect.height() / 2 - iconRect.height() / 2)));

    QImage thumbnail = index.data(PlaylistListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/scalable/hildon/qgn_list_gene_playlist.png");
    }

    painter->drawImage(iconRect, thumbnail);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 80, textRect.top() + 5));
    textRect.setRight(textRect.right() - 8);
    textRect.setBottom(textRect.bottom() - 5);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(PlaylistListModel::TitleRole).toString());

    painter->setPen(QApplication::palette().color(QPalette::Mid));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, QString("%1 - %2").arg(index.data(PlaylistListModel::DateRole).toString()).arg(index.data(PlaylistListModel::ArtistRole).toString()));
    painter->restore();
}
