#ifndef NOWPLAYINGLISTTAB_H
#define NOWPLAYINGLISTTAB_H

#include <QWidget>

class QListView;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class NowPlayingListTab : public QWidget
{
    Q_OBJECT

public:
    explicit NowPlayingListTab(QWidget *parent = 0);
    ~NowPlayingListTab();

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private:
    void connectPlaybackSignals();
    void disconnectPlaybackSignals();

private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void playSelectedTrack();
    void removeSelectedTrack();
    void onCurrentIndexChanged(int index);

private:
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_playAction;
    QAction *m_removeAction;
    QAction *m_clearAction;
    QVBoxLayout *m_vbox;
};

#endif // NOWPLAYINGLISTTAB_H
