#include "mediaplayerbutton.h"
#include "../mediaplayer/phonon/mediaplayer.h"
#include "../base/playbacklistmodel.h"
#include <QPainter>
#include <QPaintEvent>

MediaPlayerButton::MediaPlayerButton(Role buttonRole, QWidget *parent) :
    QAbstractButton(parent),
    m_role(buttonRole)
{
    this->setFixedSize(88, 75);
    this->setEnabled(false);
}

MediaPlayerButton::~MediaPlayerButton() {}

void MediaPlayerButton::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    QString state("normal");

    if (!this->isEnabled()) {
        state = "disabled";
    }
    else if (this->isDown()) {
        state = "pressed";
    }

    switch (m_role) {
    case Previous:
        painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer1_%1.png").arg(state)));
        break;
    case PlayPause:
        if (MediaPlayer::instance()->playing()) {
            painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer2_pause_%1.png").arg(state)));
        }
        else {
            painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer2_%1.png").arg(state)));
        }
        break;
    case Stop:
        painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer3_%1.png").arg(state)));
        break;
    case Next:
        painter.drawImage(this->rect(), QImage(QString("/usr/share/themes/default/images/qgn_plat_button_mplayer4_%1.png").arg(state)));
        break;
    default:
        this->icon().paint(&painter, this->rect());
        break;
    }

    event->accept();
}
