#include "homescreendelegate.h"
#include "../base/homescreenmodel.h"
#include <QPainter>

HomescreenDelegate::HomescreenDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void HomescreenDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + (option.rect.height() / 2 - iconRect.height() / 2)));

    painter->drawImage(iconRect, QImage(index.data(HomescreenModel::IconSourceRole).toString()).scaled(iconRect.size(), Qt::IgnoreAspectRatio, Qt::SmoothTransformation));

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 80);
    textRect.setRight(textRect.right() - 8);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(HomescreenModel::NameRole).toString());
}
