#ifndef GROUPLISTWINDOW_H
#define GROUPLISTWINDOW_H

#include "../base/enums.h"
#include <QWidget>

class QListView;
class GroupListModel;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class GroupListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit GroupListWindow(QWidget *parent = 0);
    ~GroupListWindow();

    void setGroupFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);
    
private slots:
    void onListItemActivated(const QModelIndex &index);

private:
    GroupListModel *m_model;
    QListView *m_view;
    QVBoxLayout *m_vbox;
};

#endif // GROUPLISTWINDOW_H
