#include "buttonbar.h"
#include <QGridLayout>
#include <QAbstractButton>
#include <QPaintEvent>
#include <QPainter>

ButtonBar::ButtonBar(QWidget *parent) :
    QWidget(parent),
    m_grid(new QGridLayout(this))
{
    this->setFixedWidth(112);

    m_grid->setContentsMargins(0, 0, 0, 0);
}

ButtonBar::~ButtonBar() {}

void ButtonBar::paintEvent(QPaintEvent *event) {
    QPainter painter(this);
    painter.drawImage(this->rect(), QImage("/usr/share/themes/default/images/qgn_plat_mediaplayer_buttons_bg.png"));

    event->accept();
}

void ButtonBar::addButton(QAbstractButton *button) {
    m_grid->addWidget(button, m_grid->count(), 0, Qt::AlignCenter);
}

void ButtonBar::insertButton(QAbstractButton *button, int index) {
    m_grid->addWidget(button, index, 0, Qt::AlignCenter);
}

void ButtonBar::removeButton(QAbstractButton *button) {
    m_grid->removeWidget(button);
}
