#include "activitylistdelegate.h"
#include "../base/activitylistmodel.h"
#include <QPainter>
#include <QApplication>

ActivityListDelegate::ActivityListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void ActivityListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    painter->save();

    QRect iconRect = option.rect;
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 5));
    iconRect.setSize(QSize(32, 32));

    QImage avatar = index.data(ActivityListModel::ArtistAvatarRole).value<QImage>();

    if (avatar.isNull()) {
        avatar = QImage("/usr/share/icons/hicolor/64x64/hildon/qgn_addr_icon_avatar.png");
    }

    painter->drawImage(iconRect, avatar);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(iconRect.right() + 8, iconRect.top()));

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(ActivityListModel::TitleRole).toString());

    textRect.setTop(textRect.top() + 32);
    textRect.setHeight(78);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop | Qt::TextWordWrap, index.data(ActivityListModel::BodyRole).toString());
    painter->setClipping(false);

    iconRect.moveTopLeft(QPoint(textRect.left(), textRect.bottom() + 8));
    iconRect.setSize(QSize(64, 64));

    QImage thumbnail = index.data(ActivityListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/scalable/hildon/qgn_list_gene_music_file.png");
    }

    painter->drawImage(iconRect, thumbnail);

    textRect.setTop(iconRect.bottom() + 8);
    textRect.setHeight(32);

    painter->setClipRect(textRect);
    painter->setPen(QApplication::palette().color(QPalette::Mid));
    painter->drawText(textRect, Qt::AlignBottom, QString("%1 - %2").arg(index.data(ActivityListModel::DateRole).toString()).arg(index.data(ActivityListModel::ArtistRole).toString()));
    painter->restore();
}

QSize ActivityListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 208);
}
