#include "aboutdialog.h"
#include "../base/utils.h"
#include <QLabel>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QVBoxLayout>
#include <QDesktopServices>
#include <QUrl>

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent),
    m_icon(new QLabel(this)),
    m_title(new QLabel("MusiKloud " + Utils::versionNumberString(), this)),
    m_details(new QLabel(tr("A fully-featured SoundCloud client. <br><br> &copy; Stuart Howarth 2011-2013"))),
    m_buttonBox(new QDialogButtonBox(Qt::Horizontal, this)),
    m_donateButton(m_buttonBox->addButton(tr("Donate"), QDialogButtonBox::ActionRole)),
    m_bugButton(m_buttonBox->addButton(tr("Report bug"), QDialogButtonBox::ActionRole)),
    m_websiteButton(m_buttonBox->addButton(tr("Visit website"), QDialogButtonBox::ActionRole)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("About"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_icon->setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/apps/musikloud.png"));
    m_icon->setAlignment(Qt::AlignHCenter);

    QFont boldFont;
    boldFont.setBold(true);

    m_title->setFont(boldFont);
    m_title->setAlignment(Qt::AlignHCenter);

    m_details->setAlignment(Qt::AlignHCenter);
    m_details->setWordWrap(true);

    m_vbox->addWidget(m_icon);
    m_vbox->addWidget(m_title);
    m_vbox->addWidget(m_details);
    m_vbox->addWidget(m_buttonBox);

    this->connect(m_donateButton, SIGNAL(clicked()), this, SLOT(donate()));
    this->connect(m_bugButton, SIGNAL(clicked()), this, SLOT(reportBug()));
    this->connect(m_websiteButton, SIGNAL(clicked()), this, SLOT(visitWebsite()));
}

AboutDialog::~AboutDialog() {}

void AboutDialog::donate() {
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=MusiKloud&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted"));
    this->close();
}

void AboutDialog::reportBug() {
    QDesktopServices::openUrl(QUrl(QString("mailto:showarth@marxoft.co.uk?subject=MusiKloud %1 for Maemo4").arg(Utils::versionNumberString())));
    this->close();
}

void AboutDialog::visitWebsite() {
    QDesktopServices::openUrl(QUrl("http://marxoft.co.uk/musikloud"));
    this->close();
}
