#ifndef DAILYMOTIONUSERLISTMODEL_H
#define DAILYMOTIONUSERLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class UserListModel : public QAbstractListModel
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed
               NOTIFY feedChanged)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(bool refreshRequired
               READ refreshRequired
               NOTIFY refreshRequiredChanged)
#endif

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        UsernameRole,
#ifndef QML_USER_INTERFACE
        AvatarRole,
#endif
        AvatarUrlRole,
        TrackCountRole,
        PlaylistCountRole
    };

public:
    explicit UserListModel(QObject *parent = 0);
    ~UserListModel();
    inline QUrl feed() const { return m_feed; }
    void setFeed(const QUrl &feed);
    inline bool loading() const { return m_loading; }
    inline bool moreResults() const { return m_moreResults; }
    inline bool refreshRequired() const { return m_refresh; }
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif
    QSharedPointer<UserItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE UserItem* getFromQML(int row) const;
#endif

public slots:
    void clear();
    void reset();
    void getUsers(QUrl feed = QUrl());
    void search(const QString &query = QString());
    void getMoreUsers();
    void insertUser(int row, QSharedPointer<UserItem> user);
    void appendUser(QSharedPointer<UserItem> user);
    bool removeUser(const QVariant &value, int role = IdRole);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }
    inline void setRefreshRequired(bool refresh) { m_refresh = refresh; emit refreshRequiredChanged(refresh); }
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

private slots:
    void addUsers();
    void onFollowingChanged(const QString &id, bool followed);
    inline void onError() { setError(true); setLoading(false); }
    inline void stopLoading() { this->setLoading(false); emit countChanged(this->rowCount()); }
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);
    void refreshRequiredChanged(bool refresh);
    void feedChanged(const QUrl &feed);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QUrl m_feed;
    QString m_query;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
    bool m_refresh;
    QList< QSharedPointer<UserItem> > m_list;
};

#endif // DAILYMOTIONUSERLISTMODEL_H
