#ifndef USERITEM_H
#define USERITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QVariantMap>
#include <QString>

class UserItem : public QObject
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(QString id
               READ id
               NOTIFY idChanged)
    Q_PROPERTY(QString username
               READ username
               NOTIFY usernameChanged)
    Q_PROPERTY(QString description
               READ description
               NOTIFY descriptionChanged)
    Q_PROPERTY(QUrl avatarUrl
               READ avatarUrl
               NOTIFY avatarUrlChanged)
    Q_PROPERTY(QString fullname
               READ fullname
               WRITE setFullname
               NOTIFY fullnameChanged)
    Q_PROPERTY(QString bandname
               READ bandname
               WRITE setBandname
               NOTIFY bandnameChanged)
    Q_PROPERTY(QString city
               READ city
               WRITE setCity
               NOTIFY cityChanged)
    Q_PROPERTY(QString country
               READ country
               WRITE setCountry
               NOTIFY countryChanged)
    Q_PROPERTY(int trackCount
               READ trackCount
               NOTIFY trackCountChanged)
    Q_PROPERTY(int playlistCount
               READ playlistCount
               NOTIFY playlistCountChanged)
    Q_PROPERTY(int favouritesCount
               READ favouritesCount
               NOTIFY favouritesCountChanged)
    Q_PROPERTY(int followersCount
               READ followersCount
               NOTIFY followersCountChanged)
    Q_PROPERTY(int followingsCount
               READ followingsCount
               NOTIFY followingsCountChanged)
    Q_PROPERTY(QUrl websiteUrl
               READ websiteUrl
               WRITE setWebsiteUrl
               NOTIFY websiteUrlChanged)
    Q_PROPERTY(QString websiteTitle
               READ websiteTitle
               WRITE setWebsiteTitle
               NOTIFY websiteTitleChanged)
    Q_PROPERTY(bool online
               READ online
               NOTIFY onlineChanged)
    Q_PROPERTY(bool followed
               READ followed
               WRITE setFollowed
               NOTIFY followedChanged)
    Q_PROPERTY(Services::AudioService service
               READ service
               NOTIFY serviceChanged)
#endif

public:
    explicit UserItem(QObject *parent = 0);
    explicit UserItem(UserItem *user, QObject *parent = 0);
    explicit UserItem(const QVariantMap &user, bool followed = false, QObject *parent = 0);
    ~UserItem() {}
    Q_INVOKABLE void loadUser(UserItem *user);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; emit idChanged(id); }
    inline QString username() const { return m_username; }
    inline void setUsername(const QString &user) { m_username = user; emit usernameChanged(user); }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline QUrl avatarUrl() const { return m_avatarUrl; }
    inline void setAvatarUrl(const QUrl &url) { m_avatarUrl = url; emit avatarUrlChanged(url); }
    inline QString fullname() const { return m_fullname; }
    inline void setFullname(const QString &name) { m_fullname = name; emit fullnameChanged(name); }
    inline QString bandname() const { return m_bandname; }
    inline void setBandname(const QString &name) { m_bandname = name; emit bandnameChanged(name); }
    inline QString city() const { return m_city; }
    inline void setCity(const QString &city) { m_city = city; emit cityChanged(city); }
    inline QString country() const { return m_country; }
    inline void setCountry(const QString &country) { m_country = country; emit countryChanged(country); }
    inline int trackCount() const { return m_trackCount; }
    inline void setTrackCount(int count) { m_trackCount = count; emit trackCountChanged(count); }
    inline int playlistCount() const { return m_playlistCount; }
    inline void setPlaylistCount(int count) { m_playlistCount = count; emit playlistCountChanged(count); }
    inline int favouritesCount() const { return m_favouritesCount; }
    inline void setFavouritesCount(int count) { m_favouritesCount = count; emit favouritesCountChanged(count); }
    inline int followersCount() const { return m_followersCount; }
    inline void setFollowersCount(int count) { m_followersCount = count; emit followersCountChanged(count); }
    inline int followingsCount() const { return m_followingsCount; }
    inline void setFollowingsCount(int count) { m_followingsCount = count; emit followingsCountChanged(count); }
    inline QUrl websiteUrl() const { return m_websiteUrl; }
    inline void setWebsiteUrl(const QUrl &url) { m_websiteUrl = url; emit websiteUrlChanged(url); }
    inline QString websiteTitle() const { return m_website; }
    inline void setWebsiteTitle(const QString &title) { m_website = title; emit websiteTitleChanged(title); }
    inline bool followed() const { return m_followed; }
    inline void setFollowed(bool followed) { m_followed = followed; emit followedChanged(followed); }
    inline bool online() const { return m_online; }
    inline void setOnline(bool online) { m_online = online; emit onlineChanged(online); }
    inline Services::AudioService service() const { return m_service; }
    inline void setService(Services::AudioService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(UserItem *other) { return other->id() == this->id(); }

private slots:
    void onFollowingChanged(const QString &id, bool followed);
    void onProfileUpdated(const QString &id, const QVariantMap &profile);

signals:
    void idChanged(const QString &id);
    void usernameChanged(const QString &username);
    void descriptionChanged(const QString &description);
    void avatarUrlChanged(const QUrl &url);
    void fullnameChanged(const QString &name);
    void bandnameChanged(const QString &name);
    void cityChanged(const QString &city);
    void countryChanged(const QString &country);
    void trackCountChanged(int count);
    void playlistCountChanged(int count);
    void favouritesCountChanged(int count);
    void followersCountChanged(int count);
    void followingsCountChanged(int count);
    void websiteUrlChanged(const QUrl &url);
    void websiteTitleChanged(const QString &title);
    void followedChanged(bool followed);
    void onlineChanged(bool online);
    void serviceChanged(Services::AudioService service);

private:
    QString m_id;
    QString m_username;
    QString m_description;
    QUrl m_avatarUrl;
    QString m_fullname;
    QString m_bandname;
    QString m_city;
    QString m_country;
    int m_trackCount;
    int m_playlistCount;
    int m_favouritesCount;
    int m_followersCount;
    int m_followingsCount;
    QUrl m_websiteUrl;
    QString m_website;
    bool m_followed;
    bool m_online;
    Services::AudioService m_service;
};

#endif // USERITEM_H
