#include "useritem.h"
#include "soundcloud.h"

UserItem::UserItem(QObject *parent) :
    QObject(parent),
    m_trackCount(0),
    m_playlistCount(0),
    m_favouritesCount(0),
    m_followersCount(0),
    m_followingsCount(0),
    m_followed(false),
    m_online(false),
    m_service(Services::NoService)
{
    this->connect(SoundCloud::instance(), SIGNAL(followingChanged(QString,bool)), this, SLOT(onFollowingChanged(QString,bool)));
}

UserItem::UserItem(UserItem *user, QObject *parent) :
    QObject(parent),
    m_id(user->id()),
    m_username(user->username()),
    m_description(user->description()),
    m_avatarUrl(user->avatarUrl()),
    m_fullname(user->fullname()),
    m_bandname(user->bandname()),
    m_city(user->city()),
    m_country(user->country()),
    m_trackCount(user->trackCount()),
    m_playlistCount(user->playlistCount()),
    m_favouritesCount(user->favouritesCount()),
    m_followersCount(user->followersCount()),
    m_followingsCount(user->followingsCount()),
    m_websiteUrl(user->websiteUrl()),
    m_website(user->websiteTitle()),
    m_followed(user->followed()),
    m_online(user->online()),
    m_service(user->service())
{
    this->connect(SoundCloud::instance(), SIGNAL(followingChanged(QString,bool)), this, SLOT(onFollowingChanged(QString,bool)));
}

UserItem::UserItem(const QVariantMap &user, bool followed, QObject *parent) :
    QObject(parent),
    m_id(user.value("id").toString()),
    m_username(user.value("username").toString()),
    m_description(user.value("description").toString().remove('\r')),
    m_avatarUrl(user.value("avatar_url").toString()),
    m_fullname(user.value("full_name").toString()),
    m_bandname(user.value("discogs_name").toString()),
    m_city(user.value("city").toString()),
    m_country(user.value("country").toString()),
    m_trackCount(user.value("track_count").toInt()),
    m_playlistCount(user.value("playlist_count").toInt()),
    m_favouritesCount(user.value("public_favorites_count").toInt()),
    m_followersCount(user.value("followers_count").toInt()),
    m_followingsCount(user.value("followings_count").toInt()),
    m_websiteUrl(user.value("website").toString()),
    m_website(user.value("website_title").toString()),
    m_followed(followed),
    m_online(user.value("online").toBool()),
    m_service(Services::SoundCloud)
{
    this->connect(SoundCloud::instance(), SIGNAL(followingChanged(QString,bool)), this, SLOT(onFollowingChanged(QString,bool)));
}

void UserItem::loadUser(UserItem *user) {
    this->setId(user->id());
    this->setUsername(user->username());
    this->setDescription(user->description());
    this->setAvatarUrl(user->avatarUrl());
    this->setFullname(user->fullname());
    this->setBandname(user->bandname());
    this->setCity(user->city());
    this->setCountry(user->country());
    this->setTrackCount(user->trackCount());
    this->setPlaylistCount(user->playlistCount());
    this->setFavouritesCount(user->favouritesCount());
    this->setFollowersCount(user->followersCount());
    this->setFollowingsCount(user->followingsCount());
    this->setWebsiteUrl(user->websiteUrl());
    this->setWebsiteTitle(user->websiteTitle());
    this->setFollowed(user->followed());
    this->setOnline(user->online());
    this->setService(user->service());
}

void UserItem::onFollowingChanged(const QString &id, bool followed) {
    if (id == this->id()) {
        this->setFollowed(followed);
    }
}

void UserItem::onProfileUpdated(const QString &id, const QVariantMap &profile) {
    if (id == this->id()) {
        this->setDescription(profile.value("description").toString().remove('\r'));
        this->setFullname(profile.value("full_name").toString());
        this->setBandname(profile.value("discogs_name").toString());
        this->setWebsiteUrl(profile.value("website").toString());
        this->setWebsiteTitle(profile.value("website_title").toString());
    }
}
