#include "settings.h"
#include <QDir>
#include <QDesktopServices>

Settings* Settings::m_instance = 0;

Settings::Settings(QObject *parent) :
    QSettings(QString("MusiKloud"), QString("MusiKloud"), parent),
    m_scrobble(false),
    m_archiveOnline(false),
    m_autoTransfers(true),
    m_maxConcurrentTransfers(1),
    m_searchOrder(Queries::Hotness),
    m_searchType(Queries::Tracks),
  #if (defined (SYMBIAN_OS) || (defined (MEEGO_EDITION_HARMATTAN)))
    m_activeColor("#0881cb"),
    m_activeColorString("color7"),
  #endif
    m_language("en"),
  #ifdef MEDIA_PLAYERS_ENABLED
    m_mediaplayer("musikloud"),
  #endif
  #ifndef SYMBIAN_OS
    m_monitorClipboard(false),
  #endif
    m_orientation(ScreenOrientation::Automatic)
  #ifdef Q_WS_MAEMO_5
    ,m_eventFeedEnabled(false),
    m_eventFeedInstalled(false)
  #endif
{
    if (!m_instance) {
        m_instance = this;
    }
}

Settings::~Settings() {
    this->saveSettings();
}

Settings* Settings::instance() {
    return !m_instance ? new Settings : m_instance;
}

void Settings::restoreSettings() {
    this->beginGroup("Media");
    this->setScrobbleTracks(this->value("scrobbleTracks", false).toBool());
    this->setArchiveOnline(this->value("archiveOnline", false).toBool());
#if (defined (Q_WS_MAEMO_5)) || (defined (Q_WS_MAEMO_4)) || (defined (MEEGO_EDITION_HARMATTAN))
    this->setDownloadPath(this->value("downloadPath", QString("/home/user/MyDocs/MusiKloud/")).toString());
#elif defined (SYMBIAN_OS)
    this->setDownloadPath(this->value("downloadPath", QString("E:/MusiKloud/")).toString());
#else
    this->setDownloadPath(this->value("downloadPath", QDesktopServices::storageLocation(QDesktopServices::MusicLocation).append("/MusiKloud/")).toString());
#endif
    this->setCreateArtistSubfolders(this->value("createArtistSubfolders", true).toBool());
    this->setDownloadFormat(static_cast<AudioFormats::Format>(this->value("downloadFormat", AudioFormats::OriginalFormat).toInt()));
#ifdef MEDIA_PLAYERS_ENABLED
    this->setMediaPlayer(this->value("mediaPlayer", QString("musikloud")).toString());
#ifndef SYMBIAN_OS
    this->setMediaPlayerCommand(this->value("mediaPlayerCommand", QString()).toString());
#endif
#endif
    this->endGroup();

    this->beginGroup("Transfers");
    this->setStartTransfersAutomatically(this->value("startTransfersAutomatically", true).toBool());
    this->setMaximumConcurrentTransfers(this->value("maximumConcurrentTransfers", 1).toInt());
    this->endGroup();

    this->beginGroup("Search");
    this->setSearchOrder(static_cast<Queries::QueryOrder>(this->value("searchOrder", Queries::Hotness).toInt()));
    this->setSearchType(static_cast<Queries::QueryType>(this->value("searchType", Queries::Tracks).toInt()));
    this->endGroup();

#ifdef Q_WS_MAEMO_5
    this->beginGroup("Events");
    this->setEventFeedEnabled((this->value("eventFeedEnabled", false).toBool()) && (this->eventFeedInstalled()));
    this->endGroup();
#endif

#ifdef MEEGO_EDITION_HARMATTAN
    this->beginGroup("Appearance");
    this->setActiveColor(this->value("activeColor", QString("#0881cb")).toString());
    this->setActiveColorString(this->value("activeColorString", QString("color7")).toString());
    this->endGroup();
#endif

    this->beginGroup("System");
    this->setLanguage(this->value("language", QString("en")).toString());
    this->setScreenOrientation(static_cast<ScreenOrientation::Orientation>(this->value("screenOrientation", ScreenOrientation::Automatic).toInt()));
#ifndef SYMBIAN_OS
    this->setMonitorClipboard(this->value("monitorClipboard", false).toBool());
#endif
    this->endGroup();
}

void Settings::saveSettings() {
    this->beginGroup("Media");
    this->setValue("scrobbleTracks", this->scrobbleTracks());
    this->setValue("archiveOnline", this->archiveOnline());
    this->setValue("downloadPath", this->downloadPath());
    this->setValue("createArtistSubfolders", this->createArtistSubfolders());
    this->setValue("downloadFormat", AudioFormats::Format(this->downloadFormat()));
#ifdef MEDIA_PLAYERS_ENABLED
    this->setValue("mediaPlayer", this->mediaPlayer());
#ifndef SYMBIAN_OS
    this->setValue("mediaPlayerCommand", this->mediaPlayerCommand());
#endif
#endif
    this->endGroup();

    this->beginGroup("Transfers");
    this->setValue("startTransfersAutomatically", this->startTransfersAutomatically());
    this->setValue("maximumConcurrentTransfers", this->maximumConcurrentTransfers());
    this->endGroup();

    this->beginGroup("Search");
    this->setValue("searchOrder", Queries::QueryOrder(this->searchOrder()));
    this->setValue("searchType", Queries::QueryType(this->searchType()));
    this->endGroup();

#ifdef Q_WS_MAEMO_5
    this->beginGroup("Events");
    this->setValue("eventFeedEnabled", (this->eventFeedEnabled()) && (this->eventFeedInstalled()));
    this->endGroup();
#endif

#ifdef MEEGO_EDITION_HARMATTAN
    this->beginGroup("Appearance");
    this->setValue("activeColor", this->activeColor());
    this->setValue("activeColorString", this->activeColorString());
    this->endGroup();
#endif

    this->beginGroup("System");
    this->setValue("language", this->language());
    this->setValue("screenOrientation", ScreenOrientation::Orientation(this->screenOrientation()));
#ifndef SYMBIAN_OS
    this->setValue("monitorClipboard", this->monitorClipboard());
#endif
    this->endGroup();
}

void Settings::setScrobbleTracks(bool scrobble) {
    if (scrobble != this->scrobbleTracks()) {
        m_scrobble = scrobble;
        emit scrobbleTracksChanged(scrobble);
    }
}

void Settings::setArchiveOnline(bool online) {
    if (online != this->archiveOnline()) {
        m_archiveOnline = online;
        emit archiveOnlineChanged(online);
    }
}

void Settings::setDownloadFormat(AudioFormats::Format audioFormat) {
    if (audioFormat != this->downloadFormat()) {
        m_downloadFormat = audioFormat;
        emit downloadFormatChanged(audioFormat);
    }
}

void Settings::setStartTransfersAutomatically(bool automatic) {
    if (automatic != this->startTransfersAutomatically()) {
        m_autoTransfers = automatic;
        emit startTransfersAutomaticallyChanged(automatic);
    }
}

void Settings::setMaximumConcurrentTransfers(int maximum) {
    int oldMaximum = this->maximumConcurrentTransfers();

    if ((maximum != oldMaximum) && (maximum > 0) && (maximum <= 3)) {
        m_maxConcurrentTransfers = maximum;
        emit maximumConcurrentTransfersChanged(oldMaximum, maximum);
    }
}

void Settings::setDownloadPath(const QString &path) {
    m_path = path;

    if (!m_path.endsWith("/")) {
        m_path.append("/");
    }

    QDir pathCheck(m_path + ".artwork/");

    if (pathCheck.exists(m_path + "artwork/")) {
        pathCheck.rename(m_path + "artwork/", pathCheck.path());
    }

    pathCheck.mkpath(pathCheck.path());

    emit downloadPathChanged(m_path);
}

void Settings::setCreateArtistSubfolders(bool subfolders) {
    if (subfolders != this->createArtistSubfolders()) {
        m_subfolders = subfolders;
        emit createArtistSubfoldersChanged(subfolders);
    }
}

void Settings::setSearchOrder(Queries::QueryOrder order) {
    if (order != this->searchOrder()) {
        m_searchOrder = order;
        emit searchOrderChanged(order);
    }
}

void Settings::setSearchType(Queries::QueryType type) {
    if (type != this->searchType()) {
        m_searchType = type;
        emit searchTypeChanged(type);
    }
}

#ifdef MEEGO_EDITION_HARMATTAN
void Settings::setActiveColor(const QString &color) {
    if (color != this->activeColor()) {
        m_activeColor = color;
        emit activeColorChanged(color);
    }
}

void Settings::setActiveColorString(const QString &colorString) {
    if (colorString != this->activeColorString()) {
        m_activeColorString = colorString;
        emit activeColorStringChanged(colorString);
    }
}
#endif

void Settings::setLanguage(const QString &lang) {
    if (lang != this->language()) {
        m_language = lang;
        emit languageChanged(lang);
    }
}

#ifdef MEDIA_PLAYERS_ENABLED
void Settings::setMediaPlayer(const QString &player) {
    if (player != this->mediaPlayer()) {
        m_mediaplayer = player;
        emit mediaPlayerChanged(player);
    }
}

#ifndef SYMBIAN_OS
void Settings::setMediaPlayerCommand(const QString &command) {
    if (command != this->mediaPlayerCommand()) {
        m_command = command;
        emit mediaPlayerCommandChanged(command);
    }
}
#endif
#endif

#ifndef SYMBIAN_OS
void Settings::setMonitorClipboard(bool monitor) {
    if (monitor != this->monitorClipboard()) {
        m_monitorClipboard = monitor;
        emit monitorClipboardChanged(monitor);
    }
}
#endif

void Settings::setScreenOrientation(ScreenOrientation::Orientation orientation) {
    if (orientation != this->screenOrientation()) {
        m_orientation = orientation;
        emit screenOrientationChanged(orientation);
    }
}

#ifdef Q_WS_MAEMO_5
void Settings::setEventFeedEnabled(bool enabled) {
    if (enabled != this->eventFeedEnabled()) {
        m_eventFeedEnabled = enabled;
        emit eventFeedEnabledChanged(enabled);
    }
}

bool Settings::eventFeedInstalled() const {
    return QDir().exists("/opt/hildonevents/bin/hildonevents");

}
#endif
