#include "session.h"
#include "settings.h"
#include "database.h"
#include "playbacklistmodel.h"
#include "soundcloud.h"
#include "lastfm.h"
#include "notifications.h"
#include "transfermanager.h"
#include "clipboardmonitor.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#ifdef Q_WS_MAEMO_5
#include "../maemo5/windowstack.h"
#endif
#endif
#if (defined (MEDIA_PLAYERS_ENABLED)) && (defined (QML_USER_INTERFACE))
#include "tracklauncher.h"
#endif
#include <QNetworkAccessManager>

Session* Session::m_instance = 0;

Session::Session(QObject *parent) :
    QObject(parent),
    m_nam(new QNetworkAccessManager(this)),
    m_settings(new Settings(this)),
    m_database(new Database),
  #if (defined (MEDIA_PLAYERS_ENABLED)) && (defined (QML_USER_INTERFACE))
    m_launcher(new TrackLauncher(this)),
  #endif
    m_queue(new PlaybackListModel(this)),
    m_soundcloud(new SoundCloud(this)),
    m_lastfm(new Lastfm(this)),
    m_notifications(new Notifications(this)),
    m_transferManager(new TransferManager(this)),
    m_monitor(new ClipboardMonitor(this))
  #ifndef QML_USER_INTERFACE
  ,m_cache(new ThumbnailCache)
  #ifdef Q_WS_MAEMO_5
  ,m_stack(new WindowStack(this))
  #endif
  #endif
{
    if (!m_instance) {
        m_instance = this;
    }

    this->connect(m_soundcloud, SIGNAL(signedIn(QString)), m_database, SLOT(storeSoundCloudToken(QString)));
    this->connect(m_soundcloud, SIGNAL(gotUsername(QString)), m_database, SLOT(storeSoundCloudUsername(QString)));
    this->connect(m_lastfm, SIGNAL(signedIn(QString,QString)), m_database, SLOT(storeLastfmAccount(QString,QString)));
    this->connect(m_database, SIGNAL(gotSoundCloudAccount(QString,QString)), m_soundcloud, SLOT(setCredentials(QString,QString)));
    this->connect(m_database, SIGNAL(gotSoundCloudToken(QString)), m_soundcloud, SLOT(setAccessToken(QString)));
    this->connect(m_database, SIGNAL(gotSoundCloudUsername(QString)), m_soundcloud, SLOT(setUsername(QString)));
    this->connect(m_database, SIGNAL(gotLastfmAccount(QString,QString)), m_lastfm, SLOT(setCredentials(QString,QString)));
    this->connect(m_settings, SIGNAL(maximumConcurrentTransfersChanged(int,int)), m_transferManager, SLOT(onMaximumConcurrentTransfersChanged(int,int)));

    this->connect(m_database, SIGNAL(alert(QString)), m_notifications, SLOT(onAlert(QString)));
    this->connect(m_database, SIGNAL(error(QString)), m_notifications, SLOT(onError(QString)));
    this->connect(m_database, SIGNAL(info(QString)), m_notifications, SLOT(onInfo(QString)));
    this->connect(m_soundcloud, SIGNAL(alert(QString)), m_notifications, SLOT(onAlert(QString)));
    this->connect(m_soundcloud, SIGNAL(error(QString)), m_notifications, SLOT(onError(QString)));
    this->connect(m_soundcloud, SIGNAL(info(QString)), m_notifications, SLOT(onInfo(QString)));
    this->connect(m_lastfm, SIGNAL(alert(QString)), m_notifications, SLOT(onAlert(QString)));
    this->connect(m_lastfm, SIGNAL(error(QString)), m_notifications, SLOT(onError(QString)));
    this->connect(m_lastfm, SIGNAL(info(QString)), m_notifications, SLOT(onInfo(QString)));
    this->connect(m_queue, SIGNAL(alert(QString)), m_notifications, SLOT(onAlert(QString)));
    this->connect(m_transferManager, SIGNAL(alert(QString)), m_notifications, SLOT(onAlert(QString)));
    this->connect(m_database, SIGNAL(busy(QString,int)), m_notifications, SLOT(showProgressDialog(QString,int)));
    this->connect(m_database, SIGNAL(busyProgressChanged(int)), m_notifications, SLOT(updateProgressDialog(int)));
    this->connect(m_soundcloud, SIGNAL(busy(QString,int)), m_notifications, SLOT(showProgressDialog(QString,int)));
    this->connect(m_soundcloud, SIGNAL(busyProgressChanged(int)), m_notifications, SLOT(updateProgressDialog(int)));
    this->connect(m_lastfm, SIGNAL(busy(QString,int)), m_notifications, SLOT(showProgressDialog(QString,int)));
    this->connect(m_lastfm, SIGNAL(busyProgressChanged(int)), m_notifications, SLOT(updateProgressDialog(int)));

#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
    this->connect(m_database, SIGNAL(alert(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_database, SIGNAL(error(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_database, SIGNAL(info(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_database, SIGNAL(currentOperationCancelled()), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_soundcloud, SIGNAL(alert(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_soundcloud, SIGNAL(error(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_soundcloud, SIGNAL(info(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_soundcloud, SIGNAL(currentOperationCancelled()), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_lastfm, SIGNAL(alert(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_lastfm, SIGNAL(error(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_lastfm, SIGNAL(info(QString)), m_notifications, SLOT(cancelProgressDialog()));
    this->connect(m_lastfm, SIGNAL(currentOperationCancelled()), m_notifications, SLOT(cancelProgressDialog()));
#endif

    m_soundcloud->setNetworkAccessManager(this->networkAccessManager());
    m_lastfm->setNetworkAccessManager(this->networkAccessManager());
    m_transferManager->setNetworkAccessManager(this->networkAccessManager());
    m_settings->restoreSettings();
    m_database->restoreAccounts();
#ifndef QML_USER_INTERFACE
    m_transferManager->restoreStoredDownloads();
#endif
}

Session::~Session() {
    delete m_database;
    m_database = 0;
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

Session* Session::instance() {
    return !m_instance ? new Session : m_instance;
}
