#ifndef SEARCHLISTMODEL_H
#define SEARCHLISTMODEL_H

#include <QSortFilterProxyModel>

class QStringListModel;
class QStringList;
class QSettings;

class SearchListModel : public QSortFilterProxyModel
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif
#endif

public:
    explicit SearchListModel(QObject *parent = 0);
    ~SearchListModel();
    Q_INVOKABLE QString regexMatch(QString str) const;
    inline QString query() const { return m_query; }
    void saveSearches();
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role = "display") const;
#endif
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    inline QString highlightColor() const { return m_highlight; }
    inline void setHighlightColor(const QString &color) { m_highlight = color; }
#endif

public slots:
    void addSearch(const QString &query);
    void removeSearch(int row);
    void setQuery(const QString &query);
    void clearSearches();

private:
    void setSearches(const QStringList &searches);

signals:
    void alert(const QString &message);
    void countChanged(int count);
    void queryChanged(const QString &query);

private:
    QStringListModel *m_model;
    QSettings *m_settings;
    QString m_query;
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    QString m_highlight;
#endif
};

#endif // SEARCHLISTMODEL_H
