#ifndef LASTFM_H
#define LASTFM_H

#include "trackitem.h"
#include <QObject>
#include <QMap>

class QNetworkAccessManager;
class QNetworkReply;
class QUrl;

class Lastfm : public QObject
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(QString username
               READ username
               NOTIFY usernameChanged)
    Q_PROPERTY(bool userSignedIn
               READ userSignedIn
               NOTIFY userSignedInChanged)
#endif

public:
    explicit Lastfm(QObject *parent = 0);
    ~Lastfm();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_username; }
    inline bool userSignedIn() const { return !m_token.isEmpty(); }
    inline bool busy() const { return m_busy; }
    inline bool cancelled() const { return m_cancelled; }

    static Lastfm* instance();

public slots:
    void signIn(const QString &user, const QString &pass);
    void setCredentials(const QString &user, const QString &token);
    void scrobbleTrack(const QString &artist, const QString &title);
    void cancelCurrentOperation();

private:
    QString getMd5Hash(const QString &value);
    QString getSignature(const QMap<QString, QString> &params, const QString &secret);
    QString getAuthToken(const QString &user, const QString &pass);
    QByteArray getPostData(const QMap<QString, QString> &params);
    void setBusy(bool isBusy, const QString &message = QString(), int numberOfOperations = 1);
    inline void setCancelled(bool cancelled) { m_cancelled = cancelled; }

private slots:
    void checkAccessToken();
    void postRequest(const QUrl &url, const QByteArray &data);
    void postFinished();
    void onTrackScrobbled();

signals:
    void alert(const QString &message);
    void busy(const QString &message, int numberOfOperations = 1);
    void busyProgressChanged(int progress);
    void busyChanged(bool isBusy);
    void currentOperationCancelled();
    void info(const QString &message);
    void error(const QString &errorString);
    void signedIn(const QString &user, const QString &token);
    void usernameChanged();
    void userSignedInChanged(bool signedIn);
    void postSuccessful();

private:
    static Lastfm* m_instance;
    QNetworkAccessManager *m_nam;
    QString m_username;
    QString m_token;
    bool m_busy;
    bool m_cancelled;
};

#endif // LASTFM_H
