#include "commentitem.h"
#include "utils.h"

CommentItem::CommentItem(QObject *parent) :
    QObject(parent),
    m_timestamp(0),
    m_indent(0),
    m_loading(false),
    m_service(Services::NoService)
{
}

CommentItem::CommentItem(CommentItem *comment, QObject *parent) :
    QObject(parent),
    m_id(comment->id()),
    m_body(comment->body()),
    m_artist(comment->artist()),
    m_artistId(comment->artistId()),
    m_artistAvatarUrl(comment->artistAvatarUrl()),
    m_date(comment->date()),
    m_timestamp(comment->timestamp()),
    m_trackId(comment->trackId()),
    m_indent(comment->indent()),
    m_loading(comment->loading()),
    m_service(comment->service())
{
}

CommentItem::CommentItem(const QVariantMap &comment, QObject *parent) :
    QObject(parent),
    m_id(comment.value("id").toString()),
    m_body(comment.value("body").toString()),
    m_artist(comment.value("user").toMap().value("username").toString()),
    m_artistId(comment.value("user").toMap().value("id").toString()),
    m_artistAvatarUrl(comment.value("user").toMap().value("avatar_url").toString()),
    m_date(Utils::localDateTimeFromString(comment.value("created_at").toString().section(' ', 0, 1))),
    m_timestamp(comment.value("timestamp").toLongLong()),
    m_trackId(comment.value("track_id").toString()),
    m_indent(0),
    m_loading(false),
    m_service(Services::SoundCloud)
{
}

void CommentItem::loadComment(CommentItem *comment) {
    this->setId(comment->id());
    this->setBody(comment->body());
    this->setArtist(comment->artist());
    this->setArtistId(comment->artistId());
    this->setArtistAvatarUrl(comment->artistAvatarUrl());
    this->setDate(comment->date());
    this->setTimestamp(comment->timestamp());
    this->setTrackId(comment->trackId());
    this->setIndent(comment->indent());
    this->setLoading(comment->loading());
    this->setService(comment->service());
}
