#include "archiveplaylistmodel.h"
#include "playlistlistmodel.h"
#include "database.h"
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
#include "settings.h"
#endif

ArchivePlaylistModel::ArchivePlaylistModel(QObject *parent) :
    QSortFilterProxyModel(parent),
    m_model(new PlaylistListModel(this)),
    m_loading(true)
{
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    this->setHighlightColor(Settings::instance()->activeColor());
#endif
    this->setSourceModel(m_model);
    this->setFilterRole(PlaylistListModel::TitleRole);

    this->connect(Database::instance(), SIGNAL(playlistsUpdated()), this, SLOT(reset()));
}

ArchivePlaylistModel::~ArchivePlaylistModel() {}

void ArchivePlaylistModel::clear() {
    m_model->clear();
}

void ArchivePlaylistModel::reset() {
    this->clear();
    this->getPlaylists();
}

QSharedPointer<PlaylistItem> ArchivePlaylistModel::get(int row) const {
    return m_model->get(this->mapToSource(this->index(row, 0)).row());
}

#ifdef QML_USER_INTERFACE
PlaylistItem* ArchivePlaylistModel::getFromQML(int row) const {
    return m_model->getFromQML(this->mapToSource(this->index(row, 0)).row());
}
#endif

void ArchivePlaylistModel::getPlaylists() {
    this->setLoading(true);

    QList< QSharedPointer<PlaylistItem> > playlists = Database::instance()->getPlaylists();

    while (!playlists.isEmpty()) {
        m_model->appendPlaylist(playlists.takeFirst());
    }

    emit countChanged(this->rowCount());
    this->setLoading(false);
}

void ArchivePlaylistModel::setQuery(const QString &query) {
    if (query != this->query()) {
        m_query = query;
        this->setFilterRegExp(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));
        emit dataChanged(this->index(0, 0), this->index(this->rowCount() - 1, 0));
        emit queryChanged(query);
    }
}

QString ArchivePlaylistModel::regexMatch(QString str) const {
    QRegExp re(this->filterRegExp());

    if ((!re.isEmpty()) && (re.indexIn(str) > -1)) {
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
        str.replace(re, "<u><font color=\"" + this->highlightColor() + "\">" + re.cap() + "</font></u>");
#else
        str.replace(re, "<b>" + re.cap() + "</b>");
#endif
    }

    return str;
}

QVariant ArchivePlaylistModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case PlaylistListModel::TitleRole:
        return !this->query().isEmpty() ? this->regexMatch(QSortFilterProxyModel::data(index, role).toString())
                                        : QSortFilterProxyModel::data(index, role);
    default:
        return QSortFilterProxyModel::data(index, role);
    }
}

#if QT_VERSION >= 0x040600
QVariant ArchivePlaylistModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row, 0), this->roleNames().key(role));
}
#endif

void ArchivePlaylistModel::deletePlaylist(int row) {
    QMetaObject::invokeMethod(Database::instance(), "deletePlaylist", Q_ARG(QString, this->data(this->index(row, 0), PlaylistListModel::IdRole).toString()), Q_ARG(bool, true));
}
