#include "event.h"

Event::Event() :
    m_type(Activities::Track),
    m_typeString("track"),
    m_date(0)
{
}

Event::Event(const QVariantMap &activity) :
    m_typeString(activity.value("type").toString()),
    m_date(0)
{
    if (this->activityTypeString() == "track") {
        this->loadTrack(activity);
    }
    else if (this->activityTypeString() == "playlist") {
        this->loadPlaylist(activity);
    }
    else if (this->activityTypeString() == "track-sharing") {
        this->loadTrackSharing(activity);
    }
    else if (this->activityTypeString() == "comment") {
        this->loadComment(activity);
    }
    else if (this->activityTypeString() == "favoriting") {
        this->loadFavourite(activity);
    }
    else {
        qWarning() << "Event::Event(): Unknown activity type.";
    }
}

void Event::loadTrack(const QVariantMap &track) {
    QVariantMap origin = track.value("origin").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(origin.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toUrl());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toUrl());
    this->setActivityType(Activities::Track);
}

void Event::loadPlaylist(const QVariantMap &playlist) {
    QVariantMap origin = playlist.value("origin").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(QString("%1 (%2)").arg(origin.value("title").toString()).arg("set"));
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toUrl());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toUrl());
    this->setActivityType(Activities::Playlist);
}

void Event::loadTrackSharing(const QVariantMap &track) {
    QVariantMap origin = track.value("origin").toMap().value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(origin.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toUrl());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toUrl());
    this->setActivityType(Activities::TrackSharing);
}

void Event::loadComment(const QVariantMap &comment) {
    QVariantMap origin = comment.value("origin").toMap();
    QVariantMap track = origin.value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(track.value("id").toString());
    this->setTitle(track.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toUrl());
    this->setBody(origin.value("body").toString().remove('\r'));
    this->setThumbnailUrl(track.value("artwork_url").toUrl());
    this->setActivityType(Activities::Comment);
}

void Event::loadFavourite(const QVariantMap &favourite) {
    QVariantMap origin = favourite.value("origin").toMap();
    QVariantMap track = origin.value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(track.value("id").toString());
    this->setTitle(track.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toUrl());
    this->setBody(QString("%1 %2").arg("Favourited by").arg(this->artist()));
    this->setThumbnailUrl(track.value("artwork_url").toUrl());
    this->setActivityType(Activities::Favouriting);
}
