#include "playlistlistwindow.h"
#include "playlisttrackswindow.h"
#include "playlistdelegate.h"
#include "listview.h"
#include "nowplayingbutton.h"
#include "../base/playlistlistmodel.h"
#include "../base/settings.h"
#include <QLabel>
#include <QMaemo5Style>

PlaylistListWindow::PlaylistListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_model(new PlaylistListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No sets found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new PlaylistDelegate(m_listView));
    m_listView->setMonitorScrolling(true);
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    if (Settings::instance()->mediaPlayer() == "musikloud") {
        this->connect(m_listView, SIGNAL(scrollingStarted()), NowPlayingButton::instance(), SLOT(hide()));
        this->connect(m_listView, SIGNAL(scrollingStopped()), NowPlayingButton::instance(), SLOT(poke()));
    }

    this->onOrientationChanged();
}

void PlaylistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void PlaylistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void PlaylistListWindow::setPlaylistFeed(const QUrl &feed) {
    m_model->setFeed(feed);
}

void PlaylistListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void PlaylistListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void PlaylistListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void PlaylistListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void PlaylistListWindow::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    PlaylistTracksWindow *window = new PlaylistTracksWindow(playlist, this);
    window->show();
}
