#ifndef NOWPLAYINGINFOTAB_H
#define NOWPLAYINGINFOTAB_H

#include "abstracttab.h"
#include "../base/trackitem.h"

class QLabel;
class SeparatorLabel;
class ThumbnailLabel;
class WaveformLabel;
class CommentListModel;
class ListView;
class ScrollArea;
class QAction;
class QModelIndex;

class NowPlayingInfoTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit NowPlayingInfoTab(QWidget *parent = 0);

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void connectPlaybackSignals();
    void disconnectPlaybackSignals();
    void setMenuActions();

private slots:
    void downloadTrack();
    void toggleFavourite();
    void showShareDialog();
    void showCommentDialog();
    void onFavouriteChanged(bool favourite);
    void onCommentsCountChanged(int count);
    void setThumbnails();
    void onCurrentTrackChanged(QSharedPointer<TrackItem> track);
    void onScreenLockStateChanged(bool locked);

private:
    QAction *m_commentAction;
    QAction *m_favouritesAction;
    QAction *m_downloadAction;
    QAction *m_shareAction;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    QLabel *m_genreLabel;
    QLabel *m_formatLabel;
    QLabel *m_sizeLabel;
    QLabel *m_lengthLabel;
    QLabel *m_playCountLabel;
    QLabel *m_downloadCountLabel;
    QLabel *m_descriptionLabel;
    ThumbnailLabel *m_thumbnailLabel;
    WaveformLabel *m_waveformLabel;
    SeparatorLabel *m_propertiesSeparator;
    SeparatorLabel *m_descriptionSeparator;
    SeparatorLabel *m_commentsSeparator;
    CommentListModel *m_commentsModel;
    ListView *m_commentsView;
    ScrollArea *m_scrollArea;
};

#endif // NOWPLAYINGINFOTAB_H
