#include "exploredialog.h"
#include "textlistdelegate.h"
#include "../base/exploremodel.h"
#include "listview.h"
#include "separatorlabel.h"
#include <QVBoxLayout>
#include <QUrl>

ExploreDialog::ExploreDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new ExploreModel(this)),
    m_view(new ListView(this))
{
    this->setWindowTitle(tr("Explore"));
    m_view->setModel(m_model);
    m_view->setModel(m_model);
    m_view->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignCenter, m_view));
    m_view->setMinimumHeight(m_view->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onCategoryChosen(QModelIndex)));
}

void ExploreDialog::onCategoryChosen(const QModelIndex &index) {
    emit categoryChosen(static_cast<Queries::QueryType>(index.data(ExploreModel::TypeRole).toInt()),
                        index.data(ExploreModel::NameRole).toString(),
                        index.data(ExploreModel::FeedRole).toUrl());
    this->accept();
}
