#include "downloadformatselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>

DownloadFormatSelector::DownloadFormatSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new DownloadFormatModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void DownloadFormatSelector::setValue(int value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toInt() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

AudioFormats::Format DownloadFormatSelector::currentValue() {
    return static_cast<AudioFormats::Format>(m_model->value(m_selector->currentIndex()).toInt());
}

void DownloadFormatSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
