#ifndef ACTIVITIESWINDOW_H
#define ACTIVITIESWINDOW_H

#include "stackedwindow.h"
#include "../base/trackitem.h"
#include "../base/playlistitem.h"
#include <QSharedPointer>

class ActivityListModel;
class ListView;
class QModelIndex;
class QAction;
class QLabel;

class ActivitiesWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit ActivitiesWindow(QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void onPlayClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void playTrack(QSharedPointer<TrackItem> track);
    void showUserChannel(const QModelIndex &index);

private:
    ActivityListModel *m_model;
    ListView *m_view;
    QAction *m_refreshAction;
    QLabel *m_noResultsLabel;
};

#endif // ACTIVITIESWINDOW_H
