#ifndef THUMBNAILCACHE_H
#define THUMBNAILCACHE_H

#include <QObject>
#include <QQueue>
#include <QImage>

class Thumbnail;
class QNetworkReply;
class QUrl;

class ThumbnailCache : public QObject
{
    Q_OBJECT

public:
    ThumbnailCache(QObject *parent = 0);
    ~ThumbnailCache();
    bool event(QEvent *event);

    static ThumbnailCache *instance();

public slots:
    QImage thumbnail(const QUrl &url, const QSize &scale = QSize());
    void onThumbnailDownloaded(QNetworkReply *reply);

protected:
    void run();

private:
    void nextThumbnail();    

signals:
    void thumbnailReady();
    void downloadThumbnail(const QUrl &url);

private:
    static ThumbnailCache* m_instance;
    QQueue<QUrl> m_urls;
};

#endif
