#ifndef NOTIFICATIONS_H
#define NOTIFICATIONS_H

#include <QObject>

#ifndef QML_USER_INTERFACE
class QProgressDialog;
#endif

class Notifications : public QObject
{
    Q_OBJECT

public:
    explicit Notifications(QObject *parent = 0);
#ifdef Q_WS_MAEMO_5
    static void showAlert(const QString &message);
    static void showInfo(const QString &message);
    static void showError(const QString &message);
    static void toggleBusy(bool busy);
#endif
    static Notifications* instance();
        
public slots:
    void onAlert(const QString &message);
    void onInfo(const QString &message);
    void onError(const QString &message);
    void showProgressDialog(const QString &message, int numberOfOperations);
    void updateProgressDialog(int progress);
#ifndef QML_USER_INTERFACE
    void cancelProgressDialog();
#endif

signals:
    void alert(const QString &message);
    void info(const QString &message);
    void error(const QString &message);
    void busy(const QString &message, int numberOfOperations);
    void busyProgressChanged(int progress);

private:
    static Notifications* m_instance;
#ifndef QML_USER_INTERFACE
    QProgressDialog *m_progressDialog;
#endif
};

#endif // NOTIFICATIONS_H
