#ifndef ARCHIVETRACKMODEL_H
#define ARCHIVETRACKMODEL_H

#include "trackitem.h"
#include <QSharedPointer>
#include <QSortFilterProxyModel>

class TrackListModel;

class ArchiveTrackModel : public QSortFilterProxyModel
{
    Q_OBJECT

    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString playlistId
               READ playlistId
               WRITE setPlaylistId)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif

public:
    explicit ArchiveTrackModel(QObject *parent = 0);
    ~ArchiveTrackModel();
    inline QString playlistId() const { return m_playlistId; }
    void setPlaylistId(const QString &id);
    inline bool loading() const { return m_loading; }
    inline QString query() const { return m_query; }
    QString regexMatch(QString str) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<TrackItem> get(int row) const;
    Q_INVOKABLE QList<int> selectedRows() const;
    QList< QSharedPointer<TrackItem> > selectedItems() const;
    QList< QSharedPointer<TrackItem> > allItems() const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE TrackItem* getFromQML(int row) const;
    Q_INVOKABLE QList<TrackItem*> selectedItemsFromQML() const;
    Q_INVOKABLE QList<TrackItem*> allItemsFromQML() const;
#endif
    bool itemsSelected() const;
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    inline QString highlightColor() const { return m_highlight; }
    inline void setHighlightColor(const QString &color) { m_highlight = color; }
#endif

public slots:
    void clear();
    void reset();
    void getTracks(const QString &playlistId = QString());
    void setQuery(const QString &query);
    void queueSelectedTracks();
    void deleteSelectedTracks(bool deleteFromFS = true);
    void selectAll();
    void selectNone();
    void toggleSelected(int row);
    void deleteTrack(int row, bool deleteFromFS = true);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }

signals:
    void queryChanged(const QString &query);
    void countChanged(int count);
    void loadingChanged(bool loading);
    void itemsSelectedChanged(bool selected);

private:
    TrackListModel *m_model;
    QString m_query;
    QString m_playlistId;
    bool m_loading;
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    QString m_highlight;
#endif
};

#endif // ARCHIVETRACKMODEL_H
