TEMPLATE = app
TARGET = musikloud
QT += sql network

maemo5 {
    DEFINES += MEDIA_PLAYERS_ENABLED
    QT += maemo5 dbus webkit
    CONFIG += mobility12
    MOBILITY += multimedia
    HEADERS += $$files(src/base/*.h) $$files(src/maemo5/*.h)
    SOURCES += $$files(src/base/*.cpp) $$files(src/maemo5/*.cpp)
    RESOURCES = src/maemo5/resources.qrc

    target.path = /opt/musikloud/bin
    desktop.path = /usr/share/applications/hildon
    desktop.files = desktop/maemo5/musikloud.desktop
    icon.path = /usr/share/icons/hicolor/64x64/apps
    icon.files = desktop/maemo5/musikloud64.png
    translations.path = /opt/musikloud/translations
    translations.files = $$files(src/maemo5/translations/*.*)
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/maemo5/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/maemo5/com.maemo.MusiKloud.xml

    INSTALLS += desktop icon translations dbus_service dbus_interface
}

contains(MEEGO_EDITION,harmattan) {
    DEFINES += QML_USER_INTERFACE
    QT += dbus declarative
    CONFIG += qdeclarative-boostable \
        libtuiclient \
        share-ui-common \
        mobility
    MOBILITY += multimedia
    HEADERS += $$files(src/base/*.h) $$files(src/harmattan/*.h) $$files(src/qml/*.h)
    SOURCES += $$files(src/base/*.cpp) $$files(src/harmattan/*.cpp) $$files(src/qml/*.cpp)
    RESOURCES = qml/harmattan/resources.qrc

#    OTHER_FILES += $$files(qml/harmattan/*.qml)

    target.path = /opt/musikloud/bin
    desktop.path = /usr/share/applications
    desktop.files = desktop/harmattan/musikloud.desktop
    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/harmattan/musikloud80.png
    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/harmattan/musikloud64.png
    dbus_service.path = /usr/share/dbus-1/services
    dbus_service.files = dbus/harmattan/com.maemo.MusiKloud.service
    dbus_interface.path = /usr/share/dbus-1/interfaces
    dbus_interface.files = dbus/harmattan/com.maemo.MusiKloud.xml
    contentaction.path = /usr/share/contentaction
    contentaction.files = contentaction/musikloud.xml
    resources.path = /opt/musikloud/resources
    resources.files = $$files(resources/*.*)

    INSTALLS += desktop icon80 icon64 dbus_service dbus_interface resources contentaction
}

symbian {
    DEFINES += QML_USER_INTERFACE SYMBIAN_OS
    MMP_RULES += "DEBUGGABLE_UDEBONLY"
    TARGET = musikloud_0x20068c6a
    CONFIG += qt-components mobility
    MOBILITY += multimedia
    INCLUDEPATH += MW_LAYER_SYSTEMINCLUDE
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconcoreapi
    LIBS += -L\\epoc32\\release\\armv5\\lib -lremconinterfacebase
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY += NetworkServices ReadUserData
    TARGET.UID3 = 0xE561675F //0x20068c6a
    DEPLOYMENT.display_name = MusiKloud
    VERSION = 1.4.3
    ICON = desktop/symbian/musikloud.svg

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""
    stupidnokia = "; Default dependency to Qt Quick Components for Symbian library" \
        "(0x200346DE), 1, 1, 0, {\"Qt Quick components for Symbian\"}"

    my_deployment.pkg_prerules += vendorinfo stupidnokia

    DEPLOYMENT += my_deployment

    SOURCES += $$files(src/base/*.cpp) \
        $$files(src/symbian/*.cpp) \
        $$files(src/qml/*.cpp)
    HEADERS += $$files(src/base/*.h) \
        $$files(src/symbian/*.h) \
        $$files(src/qml/*.h)
    RESOURCES = qml/symbian/resources.qrc

    OTHER_FILES += $$files(qml/symbian/*.qml)
}

INSTALLS += target
