#ifndef TRACKLISTWINDOW_H
#define TRACKLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"
#include "../base/trackitem.h"

class TrackListModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class TrackListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit TrackListWindow(QWidget *parent);
    void setTrackFeed(const QUrl &feed);
    void getGroupTracks(QSharedPointer<GroupItem> group);
    void search(const QString &query, Queries::QueryOrder order);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void addTracksToFavourites();
    void deleteTracksFromFavourites();
    void addTrackDownloads();
    void queueTracks();
    void showContextMenu(const QPoint &pos);
    void toggleFavourite();
    void addTrackDownload();
    void queueTrack();
    void onItemClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void playTrack(const QModelIndex &index);

private:
    ListView *m_listView;
    TrackListModel *m_model;
    QSharedPointer<GroupItem> m_group;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToQueueAction;
    QAction *m_trackDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_favouritesContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_trackDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // TRACKLISTWINDOW_H
