#include "grouplistwindow.h"
#include "tracklistwindow.h"
#include "grouplistdelegate.h"
#include "../base/grouplistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QMaemo5Style>

GroupListWindow::GroupListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_model(new GroupListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No groups found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new GroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    this->onOrientationChanged();
}

void GroupListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void GroupListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void GroupListWindow::setGroupFeed(const QUrl &feed) {
    m_model->getGroups(feed);
}

void GroupListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void GroupListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void GroupListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void GroupListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void GroupListWindow::showGroup(QSharedPointer<GroupItem> group) {
    TrackListWindow *window = new TrackListWindow(this);
    window->setWindowTitle(group.data()->title());
    window->getGroupTracks(group);
    window->show();
}
