/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1

SwitchItem {
    id: root

    property string key
    property string handler
    property bool initialised: false

    function setKey(key, defaultValue) {
        root.key = key;

        var value = Settings.setting(key);

        if (value === undefined) {
            root.checked = (defaultValue === "true");
        }
        else {
            root.checked = (value === "true");
        }
    }

    onCheckedChanged: {
        if (!initialised) {
            return;
        }

        Settings.setSetting(root.key, root.checked);

        if (root.handler) {
            ScriptEngine.eval(root.handler);
        }
    }
}
