/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "bluetooth.h"
#include "bluetooth_p.h"
#include <QBluetoothDeviceDiscoveryAgent>
#include <QBluetoothAddress>
#include <QDebug>

Bluetooth::Bluetooth(QObject *parent) :
    QObject(parent),
    d_ptr(new BluetoothPrivate(this))
{
}

Bluetooth::Bluetooth(BluetoothPrivate &dd, QObject *parent) :
    QObject(parent),
    d_ptr(&dd)
{
}

Bluetooth::~Bluetooth() {}

void Bluetooth::discoverDevices() {
    Q_D(Bluetooth);

    if (!d->agent) {
        d->agent = new QBluetoothDeviceDiscoveryAgent(this);
        this->connect(d->agent, SIGNAL(finished()), this, SLOT(_q_onDeviceDiscoveryFinished()));
    }

    d->agent->start();
}

BluetoothPrivate::BluetoothPrivate(Bluetooth *parent) :
    q_ptr(parent),
    agent(0)
{
}

BluetoothPrivate::~BluetoothPrivate() {}

void BluetoothPrivate::_q_onDeviceDiscoveryFinished() {
    if (!agent) {
        return;
    }

    qDebug() << agent->errorString();

    foreach (QBluetoothDeviceInfo info, agent->discoveredDevices()) {
        qDebug() << info.address().toString();
    }
}

#include "moc_bluetooth.cpp"
