/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "listselector.h"
#include "listview.h"
#include <QMaemo5ListPickSelector>

ListSelector::ListSelector(QWidget *parent) :
    QMaemo5ValueButton(parent),
    ControlWidget(),
    m_selector(new QMaemo5ListPickSelector(this)),
    m_view(new ListView(this))
{
    this->setContextMenuPolicy(Qt::ActionsContextMenu);

    m_selector->setModel(m_view->model());
    m_selector->setView(m_view);
    this->setPickSelector(m_selector);
    this->connect(m_view, SIGNAL(currentItemChanged(QStandardItem*)), this, SIGNAL(currentItemChanged(QStandardItem*)));
}

QStandardItem* ListSelector::currentItem() const {
    return m_view->currentItem();
}

void ListSelector::addItem(const QString &text, const QVariant &data) {
    m_view->addItem(text, data);
}

bool ListSelector::removeItem(int row) {
    return m_view->removeItem(row);
}

void ListSelector::clear() {
    m_view->clear();
}

void ListSelector::sort(Qt::SortOrder order) {
    m_view->sort(order);
}

QStandardItem* ListSelector::itemAt(int row) const {
    return m_view->itemAt(row);
}

int ListSelector::currentRow() const {
    return m_view->currentRow();
}

void ListSelector::setCurrentRow(int row) {
    m_view->setCurrentRow(row);
}
