/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CONTROLLOADER_H
#define CONTROLLOADER_H

class QDomElement;
class QObject;
class QWidget;
class Action;
class Button;
class Slider;
class Label;
class ToolButton;
class Keyboard;
class VolumeKeys;
class Dialog;
class Dpad;
class Image;
class ListSelector;
class ListView;
class Numberpad;
class RemotePage;
class RemotePageStack;
class TextField;
class Timer;
class ToolBar;
class Touchpad;

namespace ControlLoader {

QObject* loadControl(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
RemotePageStack* loadPageStack(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
RemotePage* loadPage(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Dialog* loadDialog(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Keyboard* loadKeyboard(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
VolumeKeys* loadVolumeKeys(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
Action* loadAction(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Button* loadButton(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Dpad* loadDpad(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Image* loadImage(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Label* loadLabel(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
ListSelector* loadListSelector(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
ListView* loadListView(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Numberpad* loadNumberpad(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Slider* loadSlider(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
TextField* loadTextField(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Timer* loadTimer(const QDomElement &el, bool registerHandlers, QObject *parent = 0);
ToolBar* loadToolBar(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
ToolButton* loadToolButton(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);
Touchpad* loadTouchpad(const QDomElement &el, bool registerHandlers, QWidget *parent = 0);

void loadProperties(QObject *obj, const QDomElement &el);

void loadWidgetLayout(QWidget *widget, const QDomElement &el);

void registerHandlersWithScriptEngine(QObject *obj, const QDomElement &el);

}

#endif // CONTROLLOADER_H
