/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "remotelistmodel.h"
#include "../base/definitions.h"
#include <QDir>

RemoteListModel::RemoteListModel(QObject *parent) :
    QStringListModel(parent)
{
    m_roleNames[Qt::DisplayRole] = "name";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif
    this->setStringList(QDir(REMOTES_DIRECTORY).entryList(QDir::Dirs | QDir::NoDotAndDotDot, QDir::Name));

    emit countChanged(this->rowCount());
}

RemoteListModel::~RemoteListModel() {}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> RemoteListModel::roleNames() const {
    return m_roleNames;
}
#endif
