/*
	mStatus
	
	maemo statusbar plugin to update all your social network status through Ping.fm
	
	"This product uses the Ping.fm API but is not endorsed or certified by Ping.fm."
	
	@author	Daniele Maio (b0unc3) 
	@date	22/01/2010
	@ver	1.0
	
*/

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib/gerror.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <string.h>
#include <osso-log.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>

#include "mstatus.h"

                         
#define MSTATUS_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, MSTATUS_TYPE_STATUS_MENU_ITEM, MStatusStatusMenuItemPrivate))


struct _MStatusStatusMenuItemPrivate
{
    GtkWidget *label;
    gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (MStatusStatusMenuItem, mstatus_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)

static void
mstatus_status_menu_item_class_finalize (MStatusStatusMenuItemClass *klass) {}

static void
mstatus_status_menu_item_class_init (MStatusStatusMenuItemClass *klass)
{
    g_type_class_add_private (klass, sizeof (MStatusStatusMenuItemPrivate));
}


static gboolean
update_status ( GtkWidget *btn, gpointer data )
{
	gchar *uk;
	g_file_get_contents (CONF_FILE, &uk, NULL,NULL);
	
	if ( post("http://api.ping.fm/v1/user.post",uk,"status",hildon_entry_get_text(HILDON_ENTRY(data))) )
		hildon_banner_show_information(NULL, NULL, "Your message has been posted!");
	else
		hildon_banner_show_information(NULL, NULL, "Error! Message not posted!");
		
	return FALSE;
}

static gboolean
restore_key ( GtkWidget *btn, gpointer data )
{
	system(g_strdup_printf("/bin/rm %s",CONF_FILE));
	system(g_strdup_printf("/bin/rmdir %s", CONF_DIR));
	hildon_banner_show_information(NULL, NULL, "Your old key has been removed!");
	gtk_widget_destroy(GTK_WIDGET(data));
	mstatus_wizard();
	return FALSE;
}

static void
fetch_status(void *data)
{
//	sleep(4);
	gchar *uk;
	g_file_get_contents (CONF_FILE, &uk, NULL,NULL);
	gchar *res;
	res = get_last_status(g_strdup_printf("%suser.latest",URL_BASE), uk);//(gchar *)data);
	gtk_label_set_markup (GTK_LABEL (cstatus), g_strdup_printf("Latest: <b>%s</b>",res));
//	gtk_label_set_text ( GTK_LABEL(cstatus), g_strdup_printf("Latest: %s",res));
	
	//g_source_remove(timeout);
}

static gboolean
adjust_counter(GtkWidget *e, gpointer data)
{
	if ( GTK_IS_WIDGET(e) ) 
//		if ( (140-strlen(gtk_entry_get_text(GTK_ENTRY(sentry)))) > 0 )
			gtk_label_set_text ( GTK_LABEL(cnt), g_strdup_printf("(%d)",(140-strlen(gtk_entry_get_text(GTK_ENTRY(sentry))))));
//		else
		
		
	return FALSE;
		
}
static gboolean
is_user_ok()
{
	//check if the user is valid
	gchar *contents;
	
	if ( !g_file_get_contents (CONF_FILE, &contents, NULL,NULL) ) {
		hildon_banner_show_information(NULL, NULL, "Unable to validate user!\nPlease verify your key or your connection.");
		//gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
		gtk_widget_set_sensitive ( GTK_WIDGET(update_btn), FALSE );
		return FALSE;
	} else if ( contents != NULL ) { 
		if ( !verify(g_strdup_printf("%suser.validate",URL_BASE), contents) ) {
			hildon_banner_show_information(NULL, NULL, "Unable to validate user!\nPlease verify your key or your connection.");
			//gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
			gtk_widget_set_sensitive ( GTK_WIDGET(update_btn), FALSE );
			return FALSE;
		}
	} else {
		hildon_banner_show_information(NULL, NULL, "Unable to validate user!\nPlease verify your key or your connection.");
                //gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
                gtk_widget_set_sensitive ( GTK_WIDGET(update_btn), FALSE );
                return FALSE;
	}

	gtk_widget_set_sensitive ( GTK_WIDGET(update_btn), TRUE );
//	gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, TRUE);
	return TRUE;
	
}


static gboolean
some_page_func (GtkNotebook *nb,
                gint current,
                gpointer userdata)
{
	HildonEntry *kentry;
	switch (current) {
		case 1:
			kentry = HILDON_ENTRY (gtk_notebook_get_nth_page (nb, current));
			return (strlen (hildon_entry_get_text (kentry)) != 0);
		default:
			return TRUE;
	}

}
static gboolean
mstatus_wizard()
{
	/*std for g_spawn*/
        GError  *error = NULL;
        gchar   *out;
        gchar   *err;
        gint    exit;
        gint	res;


	/* settings wizard */
	if ( !g_file_test(CONF_DIR, G_FILE_TEST_IS_DIR) ) { 
	gchar *mk = g_strdup_printf("/bin/mkdir \"%s\"",CONF_DIR);
	if (g_spawn_command_line_sync(mk,&out,&err,&exit,&error) ) {
		if ( strlen(err) > 2 ) {
			hildon_banner_show_information(NULL, NULL, g_strdup_printf("[Error] creating conf directory : %s",error->message));
                        return FALSE;
		}
	} else {
		hildon_banner_show_information(NULL, NULL, "Error during the creation of the conf directory!\n");
		return FALSE;
	}
	}

	GtkWidget *notebook = gtk_notebook_new ();
	GtkWidget *label_1 = gtk_label_new ("To use this software , you need the ping.fm key\nGet it there : http://ping.fm/key/\nCopy the key and paste it in the next entry");GtkWidget *entry_2 = hildon_entry_new (HILDON_SIZE_AUTO);
	hildon_gtk_entry_set_placeholder_text (GTK_ENTRY (entry_2), " Your Ping.fm key");
	GtkWidget *label_3 = gtk_label_new ("All done. Now you can update your status!");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), label_1, NULL);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), entry_2, NULL);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), label_3, NULL);
	GtkWidget *dialog = hildon_wizard_dialog_new (NULL, "mStatus Wizard", GTK_NOTEBOOK (notebook));
	hildon_wizard_dialog_set_forward_page_func (HILDON_WIZARD_DIALOG (dialog), some_page_func, NULL, NULL);

	gtk_widget_show (GTK_WIDGET(label_1));
	gtk_widget_show_all (dialog);
	res = gtk_dialog_run(GTK_DIALOG(dialog));
        if ( res == 2 ) {
        	FILE *f;
        	f = fopen(CONF_FILE, "w");          /* Open conf file to write data */
		fputs((char *)gtk_entry_get_text(GTK_ENTRY(entry_2)), f);
		fclose(f);
		gtk_widget_destroy(dialog);
		return TRUE;
	}

	gtk_widget_destroy(dialog);
	
	return FALSE;

}
static void
mstatus_ui ( GtkWidget *button, gconstpointer user_data G_GNUC_UNUSED)
{
	GtkWidget *toplevel = gtk_widget_get_toplevel(button);
   	gtk_widget_hide (toplevel); 
   	
   	if ( !g_file_test(CONF_FILE,G_FILE_TEST_IS_REGULAR) ) {
		if ( mstatus_wizard() ) {  }
	} else {
		GError *error;
		gchar *status;
		status = "Fetching...";
//		timeout = gdk_threads_add_timeout (1, fetch_status, uk);
//		status = get_last_status(g_strdup_printf("%suser.latest",URL_BASE),uk);
	//	GtkWidget *dialog;
		GtkWidget *box;
		GtkWidget *dbox;
		gint response;
		
		dialog = hildon_dialog_new_with_buttons("mStatus: set your status",
							NULL,//GTK_WINDOW(data),
							GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
							NULL);

		GtkWidget *rbox;
		GtkWidget *ico;
		GtkWidget *reset_btn;

		rbox = gtk_vbox_new ( 3, FALSE );
		update_btn = hildon_button_new_with_text ( HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,  HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, "Update", NULL );
		reset_btn  = hildon_button_new_with_text ( HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, "Reset key", NULL );
		ico = gtk_image_new_from_file ( MSTATUS_BIG_ICON );
		/*btnico = hildon_button_new( HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL );
		hildon_button_set_image ( HILDON_BUTTON(btnico), ico );
		gtk_button_set_relief ( GTK_BUTTON(btnico), GTK_RELIEF_NONE );
		gtk_button_set_focus_on_click ( GTK_BUTTON(btnico), FALSE );
*/

		gtk_box_pack_start ( GTK_BOX(rbox), ico, FALSE,FALSE, 0);//TRUE,TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX(rbox), reset_btn, FALSE,FALSE, 0 );//TRUE,TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX(rbox), update_btn, FALSE,FALSE, 0);
		
		/*
							GTK_STOCK_HELP,
							GTK_RESPONSE_HELP,
							"Reset key",
							GTK_RESPONSE_PROPERTIES,
							"Update",
							GTK_RESPONSE_REFRESH,
							NULL);
				
		GtkWidget *btnico;
	        btnico = gtk_dialog_get_widget_for_response ( GTK_DIALOG(dialog), GTK_RESPONSE_HELP );
 * 		gtk_button_set_relief ( GTK_BUTTON(btnico), GTK_RELIEF_NONE );
		GtkWidget *icob = gtk_image_new_from_file ( "/usr/share/pixmaps/mstatus.png" );
		
		//gtk_dialog_add_action_widget (GTK_DIALOG(dialog), icob, 1);
		gtk_button_set_image ( GTK_BUTTON(btnico), icob );
		*/
		//gtk_widget_set_sensitive ( GTK_WIDGET(btnico), FALSE );	
		box = gtk_vbox_new(2,FALSE);
		dbox= gtk_hbox_new(0,FALSE);
		cstatus = gtk_label_new(NULL);
		gtk_label_set_markup (GTK_LABEL (cstatus), g_strdup_printf("Latest: <b>%s</b>",status));
		gtk_label_set_line_wrap ( GTK_LABEL(cstatus), TRUE );
		gtk_label_set_line_wrap_mode ( GTK_LABEL(cstatus), PANGO_WRAP_WORD_CHAR );
		sentry = hildon_entry_new(HILDON_SIZE_AUTO);
		cnt = gtk_label_new("(140)");
		gtk_entry_set_max_length (GTK_ENTRY(sentry), 140);
//		gtk_widget_set_can_focus ( GTK_WIDGET(cstatus), TRUE );
				
		gtk_box_pack_start(GTK_BOX(dbox),sentry, TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(dbox),cnt, FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(box), cstatus, FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(box), dbox, FALSE,TRUE,0);
		
		g_signal_connect ( G_OBJECT(sentry), "changed", G_CALLBACK(adjust_counter), NULL );
		g_signal_connect ( G_OBJECT(update_btn), "clicked", G_CALLBACK(update_status), sentry );
		g_signal_connect ( G_OBJECT(reset_btn), "clicked", G_CALLBACK(restore_key), dialog );

		gtk_widget_set_sensitive ( GTK_WIDGET(update_btn), FALSE );
//		gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
		
		g_thread_create(is_user_ok, NULL, FALSE, &error);
		g_thread_create(fetch_status, NULL, FALSE, &error);
		/*
		if ( !is_user_ok() ) {
			hildon_banner_show_information(NULL, NULL, "Unable to validate user!\nPlease verify your key or your connection.");
			gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
		}*/
			
		gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), box);
		gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->action_area), rbox ); //btnico );
		
		gtk_widget_show_all ( GTK_WIDGET(dialog) );
		//response = 
		gtk_dialog_run(GTK_DIALOG(dialog));
		/*if (response == GTK_RESPONSE_PROPERTIES) {
			
		} else if ( response == GTK_RESPONSE_REFRESH ) {
			//update status
			
		}*/
				
		gtk_widget_destroy(GTK_WIDGET(dialog));

	}
	
}

static void
mstatus_status_menu_item_init (MStatusStatusMenuItem *plugin)
{
    GtkWidget *b,*img;

    plugin->priv = MSTATUS_STATUS_MENU_ITEM_GET_PRIVATE (plugin);

    b = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL,"mStatus", "update your status!");

//    g_type_init();
 //   g_thread_init (NULL);
    
    img = gtk_image_new_from_file(MSTATUS_ICON);
    gtk_widget_show(img);
    hildon_button_set_image(HILDON_BUTTON(b), img);
    hildon_button_set_alignment (HILDON_BUTTON(b), 0.0, 0.0, 0.0, 0.0);
    gtk_widget_show(b);
    g_signal_connect(b, "clicked", G_CALLBACK(mstatus_ui), plugin);

    gtk_container_add (GTK_CONTAINER (plugin), b);

    gtk_widget_show_all (b);

    gtk_widget_show (GTK_WIDGET (plugin));
}


