#include "widgets/filter/filterpanel.h"

#include <QToolBar>
#include <QIcon>
#include <QVariant>
#include <QAction>
#include <QString>
#include <QVBoxLayout>
#include <QtDebug>

#include "config.h"

FilterPanel::FilterPanel(QWidget *parent) :
    QWidget(parent), mCurrentIndex(0)
{
    setLayout(new QVBoxLayout);

    createToolbar();
    connect(mToolbar, SIGNAL(actionTriggered(QAction*)), SLOT(serviceSelected(QAction*)));
}

void FilterPanel::addItem(const QIcon& icon, DriverInfo* driver, bool checked)
{
    QAction* act = mActionGroup->addAction(icon, "");
    addItem(act, driver, checked);
}

void FilterPanel::addItem(const QString& string, DriverInfo* driver, bool checked)
{
    QAction* act = mActionGroup->addAction(string);
    addItem(act, driver, checked);
}

void FilterPanel::addItem(QAction* action, DriverInfo* driver, bool checked)
{
    FilteredService filteredService = {action, driver, mCurrentIndex};
    if (checked)
        mLastIndex = mCurrentIndex;

    mCurrentIndex++;

    action->setData(QVariant::fromValue(filteredService));
    action->setCheckable(true);
    action->setChecked(checked);

    mToolbar->addAction(action);
}

void FilterPanel::createToolbar()
{
    mToolbar = new QToolBar;
    mToolbar->setOrientation(Qt::Vertical);
    mToolbar->setIconSize(QSize(TOOLBAR_ICON_SIZE, TOOLBAR_ICON_SIZE));

    mActionGroup = new QActionGroup(mToolbar);

    layout()->setSpacing(0);
    layout()->setMargin(0);
    layout()->addWidget(mToolbar);
}

void FilterPanel::serviceSelected(QAction *act)
{
    const FilteredService& filteredService = act->data().value<FilteredService>();
    mLastIndex = filteredService.index;
    emit itemSelected(filteredService.driverInfo, filteredService.index);
}

void FilterPanel::clear()
{
    mCurrentIndex = 0;
    mLastIndex = -1;
    mToolbar->clear();
}

void FilterPanel::checkItem(int index)
{
    if (mLastIndex != index) {
        mToolbar->actions()[index]->setChecked(true);
        mLastIndex = index;
    }
}

QList<QAction*> FilterPanel::getServiceActions()
{
    return this->mToolbar->actions();
}

DriverInfo* FilterPanel::state() const
{
    DriverInfo* ret = 0;

    if (mActionGroup->checkedAction() != 0) {
        const FilteredService& currentFilteredService = mActionGroup->checkedAction()->data().value<FilteredService>();
        ret = currentFilteredService.driverInfo;
    }

    return ret;
}
