#ifndef QPROGRESSINDICATOR_H
#define QPROGRESSINDICATOR_H

#include <QWidget>

/*! 
    \class QProgressIndicator
    \brief The QProgressIndicator class lets an application display a progress indicator to show that a lengthy task is under way. 
 
    Progress indicators are indeterminate and do nothing more than spin to show that the
    application is busy.
    \sa QProgressBar
*/
class QProgressIndicator : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(int delay READ animationDelay WRITE setAnimationDelay)
public:
    QProgressIndicator(QWidget* parent = 0);

    /*! 
        Returns the delay, in milliseconds, between animation steps for an indeterminate progress indicator.
     
        The delay between animation steps. By default, the animation delay is set to 40 milliseconds.
        \sa setAnimationDelay
     */
    int animationDelay() const { return m_delay; }

    virtual QSize sizeHint() const;
    int heightForWidth(int w) const;
public slots:
    //! Starts the animation of an indeterminate progress indicator.
    void startAnimation();

    /*! 
        Stops the animation of an indeterminate progress indicator.
     
        @sa stopAnimation
     */
    void stopAnimation();

    /*! 
        Sets the delay, in milliseconds, between animation steps for an indeterminate progress indicator.
     
        The number of milliseconds between animation steps. By default, the animation delay is set to 40 milliseconds. 
        Setting the \a delay to a value larger than 40 slows the animation, while setting the \a delay to a smaller value speeds it up.
        \sa startAnimation
     */
    void setAnimationDelay(int delay);
protected:
    virtual void timerEvent(QTimerEvent * event); 
    virtual void paintEvent(QPaintEvent * event);
private:
    int m_angle;
    int m_timerId;
    int m_delay;
};

#endif // QPROGRESSINDICATOR_H
