#ifndef ALBUMSELECTDIALOG_H
#define ALBUMSELECTDIALOG_H

#include <QtGui/QDialog>
#include <QtCore/QHash>
#include <QtCore/QList>
#include <QtCore/QString>

namespace Ui {
    class AlbumSelectDialog;
}

class ServiceMgr;
class Friend;
class QListWidgetItem;
class Account;
class Album;

class AlbumSelectDialog : public QDialog
{
    Q_OBJECT

public:
    AlbumSelectDialog(ServiceMgr* mgr, QWidget* parent = 0);
    ~AlbumSelectDialog();

    Album selectedAlbum() const;

private:
    //! Initialize list of accounts
    void fillAccountList();

    //! Add account to list
    void addAccountToList(Account* account);

    //! Clear list of albums
    void clearList();

private slots:
    void onItemActivated(QListWidgetItem* item);
    void setSelectedAlbumItem(QListWidgetItem*);
    void on_buttonBox_accepted();


private:
    Ui::AlbumSelectDialog* ui;
    ServiceMgr* mServiceMgr;
    QHash<QListWidgetItem*, QList<QListWidgetItem*> > mAccountAlbums;
    QListWidgetItem* mLastSelectedItem;
};

#endif // ALBUMSELECTDIALOG_H
