#ifndef QFRIENDLISTMODEL_H
#define QFRIENDLISTMODEL_H

#include <QAbstractListModel>
#include <datatypes/friend.h>

class QFriendListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    explicit QFriendListModel(QObject *parent = 0):
        QAbstractListModel(parent) {};

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const;

    void setNameFilter(const QString &str);

    QModelIndex getIndex(const Friend& fr) const;
    QModelIndex getIndex(const QString& accountId, const QString& ownerId) const;
signals:

public slots:
    void updateList(const FriendList &lst);

private:
    // the whole list of friends
    FriendList frList;

    // the list of showed friends
    FriendList onlineList;

    QString nameFilter;

    void updateOnlineList();
};

#endif // QFRIENDLISTMODEL_H
