/********************
 * Callback functions
 ********************/
/*
 * Include declarations
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <glob.h>

#include <dbus/dbus.h>
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#include <libosso.h>
#include <hildon/hildon.h>
#include <hildon/hildon-fm.h>
#include <hildon/hildon-defines.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>
#include <glib/gprintf.h>
#include <glib/gfileutils.h>
#include <pango/pango.h>

#include <hildon-extras/he-helper.h>

#include "appdata.h"
#include "interface.h"
#include "callbacks.h"
#include "helpers.h"
#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

/*
 * Image file selector
 */
void open_image_file(GtkWidget *callerobj,app_data_t *myapp) {
	GtkWidget *dialog;
	GtkFileFilter *filter;
	gint retval;
	gchar *filename = NULL;
	gchar *filterext;
	guint i;
	GList *li = NULL;
	gboolean arbutenabled = FALSE;

    arbutenabled = (arrow_button_is_enabled(myapp->prevarrowbut) && arrow_button_is_enabled(myapp->nextarrowbut));
	dialog = hildon_file_chooser_dialog_new(GTK_WINDOW (myapp->mainwin),GTK_FILE_CHOOSER_ACTION_OPEN);
	if (myapp->currdir != NULL) gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (dialog),myapp->currdir);
	/* Show only supported RAW files */
    filter = gtk_file_filter_new();
	for(i = 0;myapp->rawext[i] != NULL;i++) {
		filterext = g_strconcat("*.",myapp->rawext[i],NULL);
		gtk_file_filter_add_pattern(filter,filterext);
	    g_free(filterext);
	}
	gtk_file_chooser_set_filter(GTK_FILE_CHOOSER (dialog),filter);
    if (arbutenabled) {
    	arrow_button_disable(myapp->prevarrowbut);
    	arrow_button_disable(myapp->nextarrowbut);
    }
	retval = gtk_dialog_run(GTK_DIALOG (dialog));
	if (retval == GTK_RESPONSE_ACCEPT || retval == GTK_RESPONSE_OK)
		filename = g_strndup(gtk_file_chooser_get_filename(GTK_FILE_CHOOSER (dialog)),(MAXDIRLEN + MAXFNLEN + 1));
	gtk_widget_destroy(dialog);
	if (filename != NULL) {
		g_free(myapp->currdir);
		myapp->currdir = g_strndup(g_path_get_dirname(filename),MAXDIRLEN);
		store_filenames_in_dir(myapp);
		li = g_list_find_custom(myapp->allimgindir,(gconstpointer) g_path_get_basename(filename),(GCompareFunc) g_strcmp0);
		myapp->currfindex = g_list_position(myapp->allimgindir,li);
		/* DEBUG */
		/* g_printerr("Current directory: %s - Current file: %s - Current index in list: %d\n",myapp->currdir,g_path_get_basename(filename),myapp->currfindex); */
		load_image(myapp,filename);
	} else if (arbutenabled) {
    	arrow_button_enable(myapp->prevarrowbut);
    	arrow_button_enable(myapp->nextarrowbut);
    }
	g_free(filename);
}

/*
 * Open next image in the same directory (if any)
 */
void load_next_image(GtkWidget *callerobj,app_data_t *myapp) {
	gchar *nextfn;
	GtkWidget *dialog;

	if (myapp->allimgindir != NULL) {
		if (g_list_length(myapp->allimgindir) > 1) {
			nextfn = (gchar*) g_list_nth_data(myapp->allimgindir,++myapp->currfindex);
			if (nextfn == NULL) {
				myapp->currfindex = 0;
				nextfn = (gchar*) g_list_nth_data(myapp->allimgindir,myapp->currfindex);
			}
			nextfn = g_strconcat(myapp->currdir,"/",nextfn,NULL);
			if (!g_file_test(nextfn,G_FILE_TEST_EXISTS)) {
				g_free(nextfn);
				g_free(g_list_nth_data(myapp->allimgindir,myapp->currfindex));
				myapp->allimgindir = g_list_delete_link(myapp->allimgindir,g_list_nth(myapp->allimgindir,myapp->currfindex));
				myapp->currfindex = ((myapp->currfindex > 0) ? (myapp->currfindex - 1) : (g_list_length(myapp->allimgindir) - 1));
				load_next_image(callerobj,myapp);
			} else {
				load_image(myapp,nextfn);
				g_free(nextfn);
			}
		} else {
			arrow_button_disable(myapp->prevarrowbut);
			arrow_button_disable(myapp->nextarrowbut);
			dialog = gtk_message_dialog_new(GTK_WINDOW (myapp->mainwin),
											GTK_DIALOG_DESTROY_WITH_PARENT,
											GTK_MESSAGE_WARNING,
											GTK_BUTTONS_CLOSE,
											"No more images in directory '%s'",
											myapp->currdir);
			 gtk_dialog_run(GTK_DIALOG (dialog));
			 gtk_widget_destroy(dialog);
		}
	}
}

/*
 * Open previous image in the same directory (if any)
 */
void load_prev_image(GtkWidget *callerobj,app_data_t *myapp) {
	gchar *prevfn;
	GtkWidget *dialog;

	if (myapp->allimgindir != NULL) {
		if (g_list_length(myapp->allimgindir) > 1) {
			prevfn = (gchar*) g_list_nth_data(myapp->allimgindir,--myapp->currfindex);
			if (prevfn == NULL) {
				myapp->currfindex = g_list_length(myapp->allimgindir) - 1;
				prevfn = (gchar*) g_list_nth_data(myapp->allimgindir,myapp->currfindex);
			}
			prevfn = g_strconcat(myapp->currdir,"/",prevfn,NULL);
			if (!g_file_test(prevfn,G_FILE_TEST_EXISTS)) {
				g_free(prevfn);
				g_free(g_list_nth_data(myapp->allimgindir,myapp->currfindex));
				myapp->allimgindir = g_list_delete_link(myapp->allimgindir,g_list_nth(myapp->allimgindir,myapp->currfindex));
				myapp->currfindex = ((myapp->currfindex != (g_list_length(myapp->allimgindir) - 1)) ? (myapp->currfindex + 1) : 0);
				load_next_image(callerobj,myapp);
			} else {
				load_image(myapp,prevfn);
				g_free(prevfn);
			}
		} else {
			arrow_button_disable(myapp->prevarrowbut);
			arrow_button_disable(myapp->nextarrowbut);
			dialog = gtk_message_dialog_new(GTK_WINDOW (myapp->mainwin),
											GTK_DIALOG_DESTROY_WITH_PARENT,
											GTK_MESSAGE_WARNING,
											GTK_BUTTONS_CLOSE,
											"No more images in directory '%s'",
											myapp->currdir);
			 gtk_dialog_run(GTK_DIALOG (dialog));
			 gtk_widget_destroy(dialog);
		}
	}
}

gboolean on_is_topmost_changed(GObject *object G_GNUC_UNUSED,GParamSpec *property G_GNUC_UNUSED,app_data_t *myapp) {
	if (!hildon_window_get_is_topmost(myapp->mainwin)) he_helper_accelerometer_disable(myapp->ossocont);
	else he_helper_accelerometer_enable(myapp->ossocont);

	return FALSE;
}

/*
 * Toggle image details window on or off
 */
void toggle_image_details(GtkWidget *callerobj,app_data_t *myapp) {
	GList *menuitems = NULL;

	menuitems = hildon_app_menu_get_items(hildon_window_get_app_menu(myapp->mainwin));
	if (menuitems != NULL) {
		if (!myapp->showimgparam) {
			myapp->showimgparam = TRUE;
			gtk_button_set_label(GTK_BUTTON (g_list_nth_data(menuitems,1)),"Hide details");
			g_object_set(G_OBJECT (myapp->imgparamwin),"enabled",TRUE,NULL);
			imgparam_window_show(IMGPARAM_WINDOW (myapp->imgparamwin));
		} else {
			myapp->showimgparam = FALSE;
			gtk_button_set_label(GTK_BUTTON (g_list_nth_data(menuitems,1)),"Show details");
			g_object_set(G_OBJECT (myapp->imgparamwin),"enabled",FALSE,NULL);
			imgparam_window_hide(IMGPARAM_WINDOW (myapp->imgparamwin));
		}
		g_list_free(menuitems);
	}
}

/*
 * Toggle main window's fullscreen status on or off
 */
void toggle_fullscreen_mode(GtkWidget *callerobj,app_data_t *myapp) {
	GList *menuitems = NULL;

	menuitems = hildon_app_menu_get_items(hildon_window_get_app_menu(myapp->mainwin));
	if (menuitems != NULL) {
		if (!(gdk_window_get_state(gtk_widget_get_window(GTK_WIDGET (myapp->mainwin))) & GDK_WINDOW_STATE_FULLSCREEN)) {
			gtk_window_fullscreen(GTK_WINDOW (myapp->mainwin));
			gtk_widget_set_sensitive(GTK_WIDGET (g_list_nth_data(menuitems,2)),FALSE);
		} else {
			gtk_window_unfullscreen(GTK_WINDOW (myapp->mainwin));
			gtk_widget_set_sensitive(GTK_WIDGET (g_list_nth_data(menuitems,2)),TRUE);
		}
		g_list_free(menuitems);
	}
}

/*
 * Manage key presses
 */
gboolean detect_hardware_key_press (GtkWidget *widget,GdkEventKey *event,app_data_t *myapp) {
	guint scaledwidth, scaledheight;
	zoom_t tmpzl;

	switch (event->keyval) {
		case HILDON_HARDKEY_FULLSCREEN:
		case GDK_space:
			toggle_fullscreen_mode(widget,myapp);
			return TRUE;
		case HILDON_HARDKEY_RIGHT:
		case HILDON_HARDKEY_UP:
			load_next_image(widget,myapp);
			return TRUE;
		case HILDON_HARDKEY_LEFT:
		case HILDON_HARDKEY_DOWN:
			load_prev_image(widget,myapp);
			return TRUE;
		case HILDON_HARDKEY_INCREASE:
		case HILDON_HARDKEY_DECREASE:
			tmpzl = myapp->zoomlevel;
			do {
				myapp->zoomlevel = (myapp->zoomlevel + ((event->keyval == HILDON_HARDKEY_INCREASE) ? 1 : 3)) % 4;
				scaled_image_compute_size(myapp,&scaledwidth,&scaledheight);
			} while ((myapp->zoomlevel != tmpzl) && (myapp->zoomlevel != FULL_RESOLUTION) && (scaledwidth == 0) && (scaledheight == 0));
			if (myapp->zoomlevel != tmpzl) scale_image(widget,myapp);
			return TRUE;
		default:
			break;
	}
	return FALSE;
}

/*
 * Manage main window size changes
 */
void detect_main_window_changes (GObject *object,GtkAllocation *allocation,app_data_t *myapp) {
	scale_image(GTK_WIDGET (myapp->mainwin),myapp);
}

/*
 * Detect DBus MCE signals
 */
DBusHandlerResult detect_mce_signal (DBusConnection *conn,DBusMessage *msg,app_data_t *myapp) {
	DBusMessageIter iter;
	const gchar *mode = NULL;

	if (dbus_message_is_signal(msg,MCE_SIGNAL_IF,MCE_DEVICE_ORIENTATION_SIG)) {
		if (dbus_message_iter_init(msg,&iter)) {
			dbus_message_iter_get_basic(&iter,&mode);
			/* Rotate main window */
			if (!strcmp(mode,MCE_ORIENTATION_PORTRAIT)) hildon_gtk_window_set_portrait_flags(GTK_WINDOW (myapp->mainwin),HILDON_PORTRAIT_MODE_REQUEST);
			else hildon_gtk_window_set_portrait_flags(GTK_WINDOW (myapp->mainwin),HILDON_PORTRAIT_MODE_SUPPORT);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

/*
 * Detect session D-Bus messages
 */
gint detect_dbus_message (const gchar *interface,const gchar *method,GArray *arguments,app_data_t *myapp,osso_rpc_t *retval) {
    osso_rpc_t *tmpval;
    gchar *tmpfname;

    if ((g_strncasecmp(method,"mime_open",9) == 0) & (arguments->len == 1)) {
    	/* Load requested image */
    	tmpval = &g_array_index(arguments,osso_rpc_t,0);
    	if (tmpval->type == DBUS_TYPE_STRING) {
			tmpfname = tmpval->value.s;
    		if (g_str_has_prefix(tmpval->value.s,"file://")) tmpfname += strlen("file://");
    		g_free(myapp->currdir);
    		g_free(myapp->currfname);
    		myapp->currdir = g_strndup(g_path_get_dirname(tmpfname),MAXDIRLEN);
    		myapp->currfname = g_strndup(g_path_get_basename(tmpfname),MAXFNLEN);
    		store_filenames_in_dir(myapp);
    		load_image(myapp,g_strconcat(myapp->currdir,"/",myapp->currfname,NULL));
    	} else return OSSO_ERROR;
    } else if (g_strncasecmp(method,"top_application",15) == 0) {
        /* Either show the "Open ..." dialog if there's no filename provided at startup time or automatically load last image opened */
        if (!myapp->currfname || !g_file_test(g_strconcat(myapp->currdir,"/",myapp->currfname,NULL),G_FILE_TEST_EXISTS)) open_image_file(GTK_WIDGET (myapp->mainwin),myapp);
        else load_image(myapp,g_strconcat(myapp->currdir,"/",myapp->currfname,NULL));
    }
	osso_rpc_free_val(retval);
    return OSSO_OK;
}

/*
 * Quit application
 */
void destroy_app (GtkWidget *callerobj,app_data_t *myapp) {
	/* Save configuration */
	save_configuration(myapp);
	/* Destroy widgets and quit GTK main loop */
	gtk_widget_destroy(GTK_WIDGET (myapp->mainwin));
	gtk_main_quit();
	/* Disable accelerometers */
	he_helper_accelerometer_disable(myapp->ossocont);
	/* Deinitialize OSSO context */
    osso_deinitialize(myapp->ossocont);
    /* Release memory allocated for application's data */
    app_free(myapp);
}
