#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

# mNotes
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net

import hildon
import gtk
import osso
import pango
from portrait import FremantleRotation
import os
from subprocess import *
import commands
import gobject
import mnotes_preferences
import mnotes_notes

class UndoableInsert(object):
    """something that has been inserted into our textbuffer"""
    def __init__(self, text_iter, text, length):
        self.offset = text_iter.get_offset()
        self.text = text
        self.length = length
        if self.length > 1 or self.text in ("\r", "\n", " "):
            self.mergeable = False
        else:
            self.mergeable = True

class UndoableDelete(object):
    """something that has ben deleted from our textbuffer"""
    def __init__(self, text_buffer, start_iter, end_iter):
        self.deleted_text = text_buffer.get_text(start_iter, end_iter)
        self.start = start_iter.get_offset()
        self.end = end_iter.get_offset()
        # need to find out if backspace or delete key has been used
        # so we don't mess up during redo
        insert_iter = text_buffer.get_iter_at_mark(text_buffer.get_insert())
        if insert_iter.get_offset() <= self.start:
            self.delete_key_used = True
        else:
            self.delete_key_used = False
        if self.end - self.start > 1 or self.deleted_text in ("\r", "\n", " "):
            self.mergeable = False
        else:
            self.mergeable = True

INDENT_LEVEL_1 = '• '
INDENT_LEVEL_2 = '◦ '
INDENT_LEVEL_3 = '∙ '

class Window(hildon.Window):
    
  def __init__(self,uid=None,caller=None):
    hildon.Window.__init__ (self)

    self.rotation = FremantleRotation('net.khertan.mnotes',self,mode=FremantleRotation.NEVER)

    #Prefs
    self.prefs = mnotes_preferences.Prefs()
    self.prefs.load()
#    if self.prefs.prefs_dict['auto_rotate']==True:
#      FremantleRotation('net.khertan.mnotes',main_window=caller.main_win,mode=FremantleRotation.AUTOMATIC)
#    else:
#      FremantleRotation('net.khertan.mnotes',main_window=caller.main_win,mode=FremantleRotation.NEVER)
    self.is_fullscreen = False    
    self._parent = caller

    #GUI
    self.editor=hildon.TextView()
    self.apply_prefs()

    #set wrap mode #TODO
    self.editor.set_wrap_mode(gtk.WRAP_WORD)
    self.editor.set_justification(gtk.JUSTIFY_LEFT)
    self.editor.set_indent(0)
#    self.editor.set_pixels_inside_wrap(50)


    self.toolbar = self.create_toolbar()
    self.add_toolbar(self.toolbar)
    menu = self.create_menu()
    menu.show_all()
    self.set_app_menu(menu)
    self.create_findtoolbar()
    p1 = hildon.PannableArea()
    p1.set_property('mov_mode',hildon.MOVEMENT_MODE_VERT)
    p1.add(self.editor)
    self.add(p1)
    self.show_all()

    self.note = mnotes_notes.Note(uid)    
    if uid !=None:
      self.note.load()
      
    if self.note.title!=None:
      self.set_title(self.note.title)
    else:
      self.set_title('Untitled')
    
    self.connect("key-press-event", self.on_key_press)
    self.buf = self.editor.get_buffer()
    self.buf.connect ('changed', self.on_modified)

    #title tag
    tag = self.buf.create_tag('title')
    tag.set_property('foreground','blue')
    tag.set_property('weight',pango.WEIGHT_BOLD)
    start = self.buf.get_iter_at_line (0)
    end   = self.buf.get_iter_at_line (1)
    self.buf.apply_tag_by_name ("title", start, end)

    #Create tags
    tag = self.buf.create_tag('indent_level_1')
    tag.set_property('left-margin-set',True)
    tag.set_property('left-margin',15)
    tag = self.buf.create_tag('indent_level_2')
    tag.set_property('left-margin-set',True)
    tag.set_property('left-margin',30)
    tag = self.buf.create_tag('indent_level_3')
    tag.set_property('left-margin-set',True)
    tag.set_property('left-margin',45)
    tag = self.buf.create_tag('no_indent')
    tag.set_property('left-margin-set',False)
    tag.set_property('left-margin',0)
    
    self.buf.connect_after('insert-text', self.after_insert_or_delete_text)
    self.buf.connect_after('delete-range', self.after_delete_text)
 
#    self.editor.connect_after('button-press-event', self.manage_click)
    
    self.editor.get_buffer().set_text(self.note.content)    
    
    #undo stack init
    self.undo_stack = []
    self.redo_stack = []
    self.not_undoable_action = False
    self.undo_in_progress = False

    self.buf.connect("insert-text",self._on_insert_text_undo)
    self.buf.connect("delete-range",self._on_delete_range_undo)

  @property
  def can_undo(self):
      return bool(self.undo_stack)

  @property
  def can_redo(self):
      return bool(self.redo_stack)

#  def manage_click(self,widget,event,*user):
#    buf_loc = widget.window_to_buffer_coords(widget,event.x,event.y)
#    it = widget.get_iter_at_location(buf_loc[0],buf_loc[1])
#    print it.get_line(),it.get_line_offset()
    
  def after_delete_text(self, buf, start, end):
    text = buf.get_text(start,end)
    self.after_insert_or_delete_text(buf, start, text,len(text))

  def after_insert_or_delete_text(self, buf, it, text, length):
  
    it_end = it.copy()
    it_end.forward_to_line_end()
    it.backward_chars(length)
    it.set_line_offset(0)
    line=it.get_line()

    if text=='\n':
      it_line_start = buf.get_iter_at_line(line)
      it_line_end = it_line_start.copy()
      it_line_end.forward_to_line_end()
      t=buf.get_text(it_line_start,it_line_end)
      if t.startswith(INDENT_LEVEL_1) == True:
        it_line_start = buf.get_iter_at_line(line+1)
        buf.insert(it_line_start,INDENT_LEVEL_1)
      elif t.startswith(INDENT_LEVEL_2) == True:
        it_line_start = buf.get_iter_at_line(line+1)
        buf.insert(it_line_start,INDENT_LEVEL_2)      
      elif t.startswith(INDENT_LEVEL_3) == True:
        it_line_start = buf.get_iter_at_line(line+1)
        buf.insert(it_line_start,INDENT_LEVEL_3)      
      
    text_lines = buf.get_text(it,it_end).split('\n')
    if text_lines != None:
      for text_line in text_lines:
        it_line_start = buf.get_iter_at_line(line)
        it_line_end = it_line_start.copy()
        it_line_end.forward_to_line_end()
  
        import urllib
#        print 'bufferized',buf.get_text(it_line_start,it_line_end)
#        print 'line:',line,' content:',urllib.quote(text_line)
        if (line!=0) and (text_line!=''):
          buf.remove_all_tags(it_line_start,it_line_end)
  
        if text_line.startswith(INDENT_LEVEL_1) == True:
          buf.apply_tag_by_name('indent_level_1',it_line_start,it_line_end)
#          print 'apply indent 1'
        elif text_line.startswith(INDENT_LEVEL_2) == True:
          buf.apply_tag_by_name('indent_level_2',it_line_start,it_line_end)
#          print 'apply indent 2'
        elif text_line.startswith(INDENT_LEVEL_3) == True:
          buf.apply_tag_by_name('indent_level_3',it_line_start,it_line_end)
#          print 'apply indent 3'
#        else:
#          print 'no indent'
  
        #look for existing notes
        list_store = self._parent.noteslist
        for title,uid in list_store:
          if title in text_line:
            #using regex maybe a bit overkill
            index = text_line.rfind(title)
            it_link_start = it_line_start.copy()
            it_link_start.set_line_offset(index)
            it_link_end = it_link_start.copy()
            it_link_end.forward_chars(len(title))
            tag_name = 'link:'+uid
            tag = self.buf.create_tag(tag_name)
            tag.set_property('foreground','blue')
            buf.apply_tag(tag,it_link_start,it_link_end)
                  
        line = line+1
    
  def _on_insert_text_undo(self, buf, it, text, length):
      #undo managing
      def can_be_merged(prev, cur):
          """see if we can merge multiple inserts here

          will try to merge words or whitespace
          can't merge if prev and cur are not mergeable in the first place
          can't merge when user set the input bar somewhere else
          can't merge across word boundaries"""
          WHITESPACE = (' ', '\t')
          if not cur.mergeable or not prev.mergeable:
              return False
          elif cur.offset != (prev.offset + prev.length):
              return False
          elif cur.text in WHITESPACE and not prev.text in WHITESPACE:
              return False
          elif prev.text in WHITESPACE and not cur.text in WHITESPACE:
              return False
          return True

      if not self.undo_in_progress:
          self.redo_stack = []
      if self.not_undoable_action:
          return
      undo_action = UndoableInsert(it, text, length)
      try:
          prev_insert = self.undo_stack.pop()
      except IndexError:
          self.undo_stack.append(undo_action)
          return
      if not isinstance(prev_insert, UndoableInsert):
          self.undo_stack.append(prev_insert)
          self.undo_stack.append(undo_action)
          return
      if can_be_merged(prev_insert, undo_action):
          prev_insert.length += undo_action.length
          prev_insert.text += undo_action.text
          self.undo_stack.append(prev_insert)
      else:
          self.undo_stack.append(prev_insert)
          self.undo_stack.append(undo_action)

  def delete(self):
    n = hildon.hildon_note_new_confirmation(self,'Did you want to delete this note ?')
    if n.run() == gtk.RESPONSE_OK:
      self.note.status='CANCELLED'
      self.note.save()
      self.destroy()
    n.destroy()

  def _on_delete_range_undo(self, text_buffer, start_iter, end_iter):
      def can_be_merged(prev, cur):
          """see if we can merge multiple deletions here

          will try to merge words or whitespace
          can't merge if delete and backspace key were both used
          can't merge across word boundaries"""

          WHITESPACE = (' ', '\t')
          if prev.delete_key_used != cur.delete_key_used:
              return False
          if prev.start != cur.start and prev.start != cur.end:
              return False
          if cur.deleted_text not in WHITESPACE and \
             prev.deleted_text in WHITESPACE:
              return False
          elif cur.deleted_text in WHITESPACE and \
             prev.deleted_text not in WHITESPACE:
              return False
          return True

      if not self.undo_in_progress:
          self.redo_stack = []
      if self.not_undoable_action:
          return
      undo_action = UndoableDelete(text_buffer, start_iter, end_iter)
      try:
          prev_delete = self.undo_stack.pop()
      except IndexError:
          self.undo_stack.append(undo_action)
          return
      if not isinstance(prev_delete, UndoableDelete):
          self.undo_stack.append(prev_delete)
          self.undo_stack.append(undo_action)
          return
      if can_be_merged(prev_delete, undo_action):
          if prev_delete.start == undo_action.start: # delete key used
              prev_delete.deleted_text += undo_action.deleted_text
              prev_delete.end += (undo_action.end - undo_action.start)
          else: # Backspace used
              prev_delete.deleted_text = "%s%s" % (undo_action.deleted_text,
                                                   prev_delete.deleted_text)
              prev_delete.start = undo_action.start
          self.undo_stack.append(prev_delete)
      else:
          self.undo_stack.append(prev_delete)
          self.undo_stack.append(undo_action)

  def create_findtoolbar(self):
    self.findToolBar = hildon.FindToolbar("Search for :")
    self.add_toolbar(self.findToolBar)

    self.findToolBar.connect("close", self.onHideFind)
    self.findToolBar.connect("search", self.onSearchFind)
    self.findToolBar.set_no_show_all(True)

  def begin_not_undoable_action(self):
      """don't record the next actions

      toggles self.not_undoable_action"""
      self.not_undoable_action = True        

  def end_not_undoable_action(self):
      """record next actions

      toggles self.not_undoable_action"""
      self.not_undoable_action = False

  def undo(self):
      """undo inserts or deletions

      undone actions are being moved to redo stack"""
      if not self.undo_stack:
          return
      self.begin_not_undoable_action()
      self.undo_in_progress = True
      undo_action = self.undo_stack.pop()
      self.redo_stack.append(undo_action)
      if isinstance(undo_action, UndoableInsert):
          start = self.buf.get_iter_at_offset(undo_action.offset)
          stop = self.buf.get_iter_at_offset(
              undo_action.offset + undo_action.length
          )
          self.buf.delete(start, stop)
          self.buf.place_cursor(start)
      else:
          start = self.buf.get_iter_at_offset(undo_action.start)
          stop = self.buf.get_iter_at_offset(undo_action.end)
          self.buf.insert(start, undo_action.deleted_text)
          if undo_action.delete_key_used:
              self.buf.place_cursor(start)
          else:
              self.buf.place_cursor(stop)
      self.end_not_undoable_action()
      self.undo_in_progress = False

  def redo(self):
      """redo inserts or deletions

      redone actions are moved to undo stack"""
      if not self.redo_stack:
          return
      self.begin_not_undoable_action()
      self.undo_in_progress = True
      redo_action = self.redo_stack.pop()
      self.undo_stack.append(redo_action)
      if isinstance(redo_action, UndoableInsert):
          start = self.buf.get_iter_at_offset(redo_action.offset)
          self.buf.insert(start, redo_action.text)
          new_cursor_pos = self.buf.get_iter_at_offset(
              redo_action.offset + redo_action.length
          )
          self.buf.place_cursor(new_cursor_pos)
      else:
          start = self.buf.get_iter_at_offset(redo_action.start)
          stop = self.buf.get_iter_at_offset(redo_action.end)
          self.buf.delete(start, stop)
          self.buf.place_cursor(start)
      self.end_not_undoable_action()
      self.undo_in_progress = False

  def onShowFind(self, widget):
    self.findToolBar.show()
    for fchild in self.findToolBar.get_children():
      try:
        for achild in fchild.get_children():
          try:
            for cchild in achild.get_children():
              if type(cchild)==gtk.ComboBoxEntry:
                self.set_focus(cchild.get_children()[0])                 
          except:
            pass
      except:
        pass

    
  def onHideFind(self, widget):
    self.findToolBar.hide()
    self.searched_text = None

  def onSearchFind(self,widget,data=None):
    text = widget.get_property("prefix")
    self.editor.search(text)

  def on_modified(self,buf,data=None):
    start,end = buf.get_bounds()
    self.note.content = buf.get_text(start,end)
    self.note.save()
    self.set_title(self.note.title)
    start = buf.get_iter_at_line (0)
    end   = buf.get_iter_at_line (1)
    buf.apply_tag_by_name ("title", start, end)


  def on_key_press(self, widget, event, *args):
    if (event.state==gtk.gdk.CONTROL_MASK):
      #New : CTRL-"
      if (event.keyval == gtk.keysyms.n):
        self._parent.note_window(None) 
      #Undo : CTRL-Z
      elif (event.keyval == gtk.keysyms.z):
        self.undo()
      #Redo : CTRL-Y
      elif (event.keyval == gtk.keysyms.y):
        self.redo()
      #Searh : CTRL-F
      #elif (event.keyval == gtk.keysyms.f):
      #  self.onShowFind(widget) 
      #Duplicate line : CTRL-D
      #elif (event.keyval == gtk.keysyms.d):
      #  self.code_editor.duplicate_line() 
      #Close : CTRL-W
      elif (event.keyval == gtk.keysyms.w):
        self.destroy() 
      #Show Info : CTRL-I
      #elif (event.keyval == gtk.keysyms.i):
      #  info = hildon.FileDetailsDialog(self,self.filepath)
      #  info.run()
      #  info.destroy()
      #Show Help
      elif (event.keyval == gtk.keysyms.h):
        self.show_help()
      #Execute
      #elif (event.keyval == gtk.keysyms.e):
      #  self.execute()

  def show_help(self):
    import mnotes_help
    mnotes_help.Help()
  
  def create_toolbar(self):
    toolbar = gtk.Toolbar()
#    label = 'Edit'
#    pbuf = gtk.IconTheme().load_icon('browser_panning_mode_off',gtk.ICON_SIZE_BUTTON,gtk.ICON_LOOKUP_USE_BUILTIN)
#    i = gtk.Image()
#    i.set_from_pixbuf(pbuf)
#
#    toolitem = gtk.ToggleToolButton()
#    toolitem.set_icon_widget(i)
#    toolitem.connect("toggled", self.toolbar_button_clicked, label)    
#    toolbar.insert(toolitem, 0)

    label = 'Indent'
    toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_INDENT,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 label)
    toolitem.connect("clicked", self.toolbar_button_clicked, label)
    toolbar.insert(toolitem, 0)

    label = 'Unindent' 
    toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_UNINDENT,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 label)
    toolitem.connect("clicked", self.toolbar_button_clicked, label)    
    toolbar.insert(toolitem, 1)

    toolbar.insert(gtk.SeparatorToolItem(),2)

    label = 'Search'
    toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_FIND,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 label)
    toolitem.connect("clicked", self.toolbar_button_clicked, label)    
    toolbar.insert(toolitem, 3)

    toolbar.insert(gtk.SeparatorToolItem(),4)

    label = 'OpenLink'
    toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_EDIT,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 label)
    toolitem.connect("clicked", self.toolbar_button_clicked, label)    
    toolbar.insert(toolitem, 5)

    toolbar.insert(gtk.SeparatorToolItem(),6)

    label = 'Fullscreen'
    toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_FULLSCREEN,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 label)
    toolitem.connect("clicked", self.toolbar_button_clicked, label)    
    toolbar.insert(toolitem, 7)

    return toolbar
    
  def indent_tab(self):
    if (self.buf.get_selection_bounds()!=()):
      start,end=self.buf.get_selection_bounds()
      for line in range(start.get_line(),end.get_line()+1):
        it_line_start = self.buf.get_iter_at_line(line)
        it_line_end = it_line_start.copy()
        it_line_end.forward_to_line_end()
        text = self.buf.get_text(it_line_start,it_line_end)
        if text.startswith(INDENT_LEVEL_1):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
          self.buf.insert(it_line_start,INDENT_LEVEL_2)
        elif text.startswith(INDENT_LEVEL_2):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
          self.buf.insert(it_line_start,INDENT_LEVEL_3)
        elif text.startswith(INDENT_LEVEL_3):
          print '3 level of indent only'
        else:
          self.buf.insert(it_line_start,INDENT_LEVEL_1)
    else:
      it_line_start = self.buf.get_iter_at_line(self.buf.get_iter_at_mark(self.buf.get_insert()).get_line())
      it_line_end = it_line_start.copy()
      it_line_end.forward_to_line_end()
      text = self.buf.get_text(it_line_start,it_line_end)
      if text.startswith(INDENT_LEVEL_1):
        it_old = it_line_start.copy()
        it_old.forward_chars(2)
        self.buf.delete(it_line_start,it_old)
        self.buf.insert(it_line_start,INDENT_LEVEL_2)
      elif text.startswith(INDENT_LEVEL_2):
        it_old = it_line_start.copy()
        it_old.forward_chars(2)
        self.buf.delete(it_line_start,it_old)
        self.buf.insert(it_line_start,INDENT_LEVEL_3)
      elif text.startswith(INDENT_LEVEL_3):
        print '3 level of indent only'
      else:
        self.buf.insert(it_line_start,INDENT_LEVEL_1)
    
  def unindent_tab(self):
    if (self.buf.get_selection_bounds()!=()):
      start,end=self.buf.get_selection_bounds()
      for line in range(start.get_line(),end.get_line()+1):
        it_line_start = self.buf.get_iter_at_line(line)
        it_line_end = it_line_start.copy()
        it_line_end.forward_to_line_end()
        text = self.buf.get_text(it_line_start,it_line_end)
        if text.startswith(INDENT_LEVEL_1):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
        elif text.startswith(INDENT_LEVEL_2):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
          self.buf.insert(it_line_start,INDENT_LEVEL_1)
        elif text.startswith(INDENT_LEVEL_3):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
          self.buf.insert(it_line_start,INDENT_LEVEL_2)
    else:
      it_line_start = self.buf.get_iter_at_line(self.buf.get_iter_at_mark(self.buf.get_insert()).get_line())
      it_line_end = it_line_start.copy()
      it_line_end.forward_to_line_end()
      text = self.buf.get_text(it_line_start,it_line_end)
      if text.startswith(INDENT_LEVEL_1):
        it_old = it_line_start.copy()
        it_old.forward_chars(2)
        self.buf.delete(it_line_start,it_old)
      elif text.startswith(INDENT_LEVEL_2):
        it_old = it_line_start.copy()
        it_old.forward_chars(2)
        self.buf.delete(it_line_start,it_old)
        self.buf.insert(it_line_start,INDENT_LEVEL_1)
      elif text.startswith(INDENT_LEVEL_3):
          it_old = it_line_start.copy()
          it_old.forward_chars(2)
          self.buf.delete(it_line_start,it_old)
          self.buf.insert(it_line_start,INDENT_LEVEL_2)
    
  def open_link(self):
    it = self.buf.get_iter_at_mark(self.buf.get_insert())
    for tag in it.get_tags():
      tag_name = tag.get_property('name')
      if tag_name.startswith('link:'):
        self._parent.note_window(tag_name[5::])
        return
    n = hildon.hildon_note_new_information(self,'No link to open.')
    n.run()
    n.destroy()
        
  def toolbar_button_clicked (self,toolbutton, label):
    print "Toolbar button clicked : %s" % label
    if label=='OpenLink':
      self.open_link()
    elif label=='Save':
      self.save()
    elif label=='Indent':
      self.indent_tab()
    elif label=='Unindent':
      self.unindent_tab()
    elif label=='Search':
      self.onShowFind(toolbutton) 
    elif label=='Fullscreen':
      self.is_fullscreen = not self.is_fullscreen
      if self.is_fullscreen==True:
        self.fullscreen()
      else:
        self.unfullscreen()
      
  def menu_button_clicked(self,button, label):
    if label == 'New':
      self._parent.note_window(None) 
    elif label=='Sync':
      import mnotes_sync
      mnotes_sync.Sync().start()
    elif label=='Delete':
      self.delete()
    elif label=='About':
      self._parent.onAbout(self)
    elif label == 'Help':
      self.show_help()
    elif label == 'Settings':
      prefs = mnotes_preferences.Prefs()
      prefs.load()
      prefs.edit(self)
    else:
      print "Menu Button clicked: %s" % label

  def create_menu(self):
    menu = hildon.AppMenu()
    #New
    self.new_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'New'
    self.new_menu_button.set_label(label)
    self.new_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.new_menu_button)
    self.about_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    self.delete_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'Delete'
    self.delete_menu_button.set_label(label)
    self.delete_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.delete_menu_button)
    self.sync_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'Sync'
    self.sync_menu_button.set_label(label)
    self.sync_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.sync_menu_button)
    self.about_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'About'
    self.about_menu_button.set_label(label)
    self.about_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.about_menu_button)
    self.settings_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'Settings'
    self.settings_menu_button.set_label(label)
    self.settings_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.settings_menu_button)
    self.help_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO) 
    label = 'Help'                                             
    self.help_menu_button.set_label(label)                   
    self.help_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.help_menu_button)                  
                                              
    return menu

  def apply_prefs(self):
    self.prefs.load()
    #rotate
    if self.prefs.prefs_dict['auto_rotate']==True:
      self.rotation.set_mode(FremantleRotation.AUTOMATIC)
    else:
      self.rotation.set_mode(FremantleRotation.NEVER)
    #font / size
    self.editor.modify_font(pango.FontDescription (self.prefs.prefs_dict['font_name']+" "+str(self.prefs.prefs_dict['font_size'])))
