#!/usr/bin/env python2.5

#
# mNotes
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net

import os
import icalendar
import uuid
import datetime
import dateutil.tz
import urllib
import urllib2
import mnotes_preferences
import hildon
import gtk
import gobject
import mnotes_notes
import thread,threading
gtk.gdk.threads_init()

class Sync():

  def __init__(self):
#    self.lock=threading.Lock()
    self.dialog = hildon.Dialog()#'Synchronization',hildon.Window(),gtk.DIALOG_DESTROY_WITH_PARENT,())
    self.dialog.set_title('Initializing Synchronization')
    self.dialog.set_modal(True)
    self.progressbar = gtk.ProgressBar()
    self.progressbar.set_text('Initializing')
#    self.progressbar.set_pulse_step(1)
#    self.dialog.add(self.progressbar)
    self.dialog.vbox.add(self.progressbar)
#    self.dialog.show_all()
    hildon.hildon_gtk_window_set_progress_indicator(self.dialog, 1)
#    self.dialog()
#    gobject.idle_add(self.sync_now)
#    t = thread.start_new_thread(self.sync_now, ())

  def start(self):
    threading.Thread(target=self.sync_now).start()
    self.dialog.show()
    
  def sync_now(self):
    
#    self.dialog.run()
    self.prefs = mnotes_preferences.Prefs()
    self.prefs.load()
    self.local_uid = [] 
    for d,r,files in os.walk(mnotes_notes.NOTES_FOLDER):
      for name in files:
        self.local_uid.append(name)  
#        self.progressbar.pulse()
    self.sync()
#    self.progressbar.pulse()
#    gtk.gdk.threads_enter()
#    self.dialog.destroy()
#    gtk.gdk.threads_leave()
    gtk.gdk.threads_enter()
    self.dialog.set_title('Sync Ended')
    self.dialog.queue_draw()
    self.dialog.hide()
    gtk.gdk.threads_leave()

    print 'Sync Ended'
    return(0)
        
  def push(self,uid):
    gtk.gdk.threads_enter()
    self.dialog.set_title('Pushing : '+uid)
    self.dialog.queue_draw()
    gtk.gdk.threads_leave()

#    self.progressbar.set_text('Pushing : '+uid)
#    self.progressbar.pulse()
    the_url = 'https://www.khertan.net/mnotes/set_one.php'
    n = mnotes_notes.Note(uid)
    n.load()
    values = {'uid' : str(n.uid),
              'content' : n.as_string(),
              'login' : self.prefs.prefs_dict['login'],
              'password' : self.prefs.prefs_dict['password'] }
    print 'CONTENT',n.as_string()

    data = urllib.urlencode(values)
    req = urllib2.Request(the_url, data)
    try:
      handle = urllib2.urlopen(req)
      the_page = handle.read()
    except StandardError,e:
      text = str(e)
      gtk.gdk.threads_enter()
      n = hildon.hildon_note_new_information(hildon.Window(),text)
      n.run()
      n.destroy()
      gtk.gdk.threads_leave()

    if the_page != 'OK':
      print 'set_one:',the_page
    else:
      print 'pushed',uid 
      
  def pull(self,uid):
    gtk.gdk.threads_enter()
    self.dialog.set_title('Retrieving : '+uid)
    self.dialog.queue_draw()
    gtk.gdk.threads_leave()
#    self.progressbar.set_text('Retrieving : '+uid)
#    self.progressbar.pulse()

    the_url = 'https://www.khertan.net/mnotes/get_one.php'
    values = {'uid' : str(uid),
              'login' : self.prefs.prefs_dict['login'],
              'password' : self.prefs.prefs_dict['password'] }
    
    data = urllib.urlencode(values)
    req = urllib2.Request(the_url, data)
    handle = urllib2.urlopen(req)
    the_page = handle.read()
#    print 'get_one content:'+the_page
    n = mnotes_notes.Note(uid)
    try:
      n.from_string(the_page)
    except StandardError,e:
      print 'get_one:',e,':',the_page
      text = str(e)
      gtk.gdk.threads_enter()
      n = hildon.hildon_note_new_information(hildon.Window(),text)
      n.run()
      n.destroy()
      gtk.gdk.threads_leave()
      return None
    return n
    
  def sync(self):
    if (self.get_distant()==True):
      #upload new local to distant
      for uid in self.local_uid:
        if uid not in self.distant_uid:
          self.push(uid)
      #download new distant to local
      for uid in self.distant_uid:
        if uid not in self.local_uid:
          self.pull(uid).save()
      #compare
      for uid in self.local_uid:
        if uid in self.distant_uid:
          local_note = mnotes_notes.Note(uid)
          local_note.load()
          distant_note = self.pull(uid)
          if distant_note!=None:
            print 'compare:',distant_note.updated, ':',local_note.updated
            if distant_note.updated < local_note.updated:
              self.push(uid)
            elif distant_note.updated == local_note.updated:
              pass
            else:
              n.save()
              #self.pull(uid)
            
  
  def get_distant(self):
    gtk.gdk.threads_enter()
    self.dialog.set_title('Getting remote list')
    self.dialog.queue_draw()
    gtk.gdk.threads_leave()
#    self.progressbar.set_text('Getting remote list')
#    self.progressbar.pulse()

    self.distant_uid = [] 
    the_url = 'https://www.khertan.net/mnotes/get.php'
    values = {
              'login' : self.prefs.prefs_dict['login'],
              'password' : self.prefs.prefs_dict['password'] }
    
    data = urllib.urlencode(values)
    req = urllib2.Request(the_url, data)
    try:
      handle = urllib2.urlopen(req)
      the_page = handle.read()
      for uid in the_page.split('\n'):
        if uid != '':
          self.distant_uid.append(uid)      
    except IOError,e:
      try:
        if e.code==403:
          print 'login and password incorrect'
          text = 'login and password incorrect'
          gtk.gdk.threads_enter()
          n = hildon.hildon_note_new_information(hildon.Window(),text)
          n.run()
          n.destroy()
          gtk.gdk.threads_leave()
        elif e.code==500:
          print 'Server error'
          text = 'Server error'
          gtk.gdk.threads_enter()
          n = hildon.hildon_note_new_information(hildon.Window(),text)
          n.run()
          n.destroy()
          gtk.gdk.threads_leave()
        else:
          print 'get:',e.msg  
          text = str(e.msg)  
          gtk.gdk.threads_enter()
          n = hildon.hildon_note_new_information(hildon.Window(),text)
          n.run()
          n.destroy()
          gtk.gdk.threads_leave()
      except:
        print 'get:',e  
        text = str(e)
        gtk.gdk.threads_enter()
        n = hildon.hildon_note_new_information(hildon.Window(),text)
        n.run()
        n.destroy()
        gtk.gdk.threads_leave()
      return False

    return True
    

if __name__ == "__main__":
  Sync().start()
  gtk.main()
