import hildon
import gtk
import cPickle
import mnotes_window 
import os

class Prefs():
  def __init__(self):
    self.prefs_dict = {}

  def load(self):
    try:
      f = open(os.path.expanduser("~")+"/.mnotes/preferences",'r')
      self.prefs_dict = cPickle.load(f)
      f.close()
    except:
      self.default()
      
  def default(self):
    self.prefs_dict['hildon_text_completion']=True
    self.prefs_dict['font_name']='Monospace'     
    self.prefs_dict['font_size']='12'     
    self.prefs_dict['auto_rotate']=True     
    self.prefs_dict['login']=''
    self.prefs_dict['password']=''

  def store(self):
    try:
      f = open(os.path.expanduser("~")+"/.mnotes/preferences",'w')
      prefs = cPickle.dump(self.prefs_dict,f)
      f.close()
    except:
      pass
  
  def edit(self,parent_window):
    dialog = gtk.Dialog('Preferences',parent_window,gtk.DIALOG_DESTROY_WITH_PARENT,(gtk.STOCK_OK,gtk.RESPONSE_ACCEPT))

    #login
    w_login = hildon.Entry(0)
    w_login.set_placeholder('login')
    if self.prefs_dict.has_key('login'):
      w_login.set_text((self.prefs_dict['login']))
    
    #password
    w_password = hildon.Entry(0)
    w_password.set_placeholder('password')
    if self.prefs_dict.has_key('password'):
      w_password.set_text((self.prefs_dict['password']))

    #hildon_text_completion
    w_hildon_text_completion = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
    w_hildon_text_completion.set_label('Hildon Text Completion')
    if self.prefs_dict.has_key('hildon_text_completion'):
      w_hildon_text_completion.set_active((self.prefs_dict['hildon_text_completion']==True))

    #auto_rotate
    w_auto_rotate = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
    w_auto_rotate.set_label('Auto Portrait Mode')
    if self.prefs_dict.has_key('auto_rotate'):
      w_auto_rotate.set_active((self.prefs_dict['auto_rotate']==True))
    
    #Font Button
    w_font = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                       hildon.BUTTON_ARRANGEMENT_VERTICAL) 
    w_font.set_title("Font")
    w_font_selector = hildon.TouchSelectorEntry(text=True)
    c = parent_window.create_pango_context()
    families = c.list_families()
    font_names = []
    for f in families:
      font_names.append(f.get_name())
    for f in font_names:
      w_font_selector.append_text(f)
    w_font.set_selector(w_font_selector)
    if self.prefs_dict.has_key('font_name'):
      w_font.set_active(font_names.index(self.prefs_dict['font_name']))
      w_font.set_value(self.prefs_dict['font_name'])
      
    #Font Size Button
    w_font_size = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                       hildon.BUTTON_ARRANGEMENT_VERTICAL) 
    w_font_size.set_title("Size")
    w_font_size_selector = hildon.TouchSelectorEntry(text=True)
    font_sizes = []
    for f in range(7,49):
      font_sizes.append(str(f))
    for f in font_sizes:
      w_font_size_selector.append_text(f)
    w_font_size.set_selector(w_font_size_selector)
    if self.prefs_dict.has_key('font_size'):
      w_font_size.set_active(font_sizes.index(self.prefs_dict['font_size']))
      w_font_size.set_value(self.prefs_dict['font_size'])
    
    dialog.vbox.add(w_hildon_text_completion)
    dialog.vbox.add(w_auto_rotate)
    hbox = gtk.HBox()
    hbox.add(w_font)
    hbox.add(w_font_size)
    dialog.vbox.add(hbox)
    dialog.vbox.add(w_login)
    dialog.vbox.add(w_password)
    #p1 = hildon.PannableArea()
    #p1.set_size_request(600,400)
#    p1.add(vbox)
#    dialog.get_child().get_child().add(p1)
#    dialog.vbox.add(p1)
    dialog.show_all()
    if(dialog.run()==gtk.RESPONSE_ACCEPT):
      self.prefs_dict['hildon_text_completion']=w_hildon_text_completion.get_active()
      self.prefs_dict['auto_rotate']=w_auto_rotate.get_active()
      self.prefs_dict['font_name']= w_font_selector.get_current_text()
      self.prefs_dict['font_size']= w_font_size_selector.get_current_text()
      self.prefs_dict['login']= w_login.get_text()
      self.prefs_dict['password']= w_password.get_text()
      self.store()
      parent_window._parent.apply_prefs()
    dialog.destroy()
        
if __name__ == "__main__":
  prefs = Prefs()
  prefs.load()
  prefs.edit(hildon.Window())
