#ifndef FCAM_F2_SHUTTERBUTTON_H
#define FCAM_F2_SHUTTERBUTTON_H

/** \file 
 * This file contains a shutter button class for the F2, which
 * uses PhidgetDevice to read out the shutter button state.
 */

#include "../Event.h"

namespace FCam { namespace F2 {
    //! Implementation of ShutterButton, encapsulates away the phidgets library headers
    class PhidgetShutterButton;
    //! A simple shutter button class that generates an FCam::Event each time the Phidget based 
    //! shutter button is pressed or released.    
    class ShutterButton : public EventGenerator {
    public:
        //! Returns a string describing the meaning of a given event generated by this object.
        virtual std::string getEventString(const Event &) const;
        //! Creates a new shutter button PhidgetDevice and registers the Phidget input indices
        //! corresponding to half and full presses. 
        ShutterButton(int halfPress = 1, int fullPress = 0);
        ~ShutterButton();

    protected:
        PhidgetShutterButton *impl;

    
    };
    }  
}

#endif
